/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.util.HashSet;
import java.util.Set;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasEntityDef {
    @Test
    public void testEntityDefSerDeEmpty() {
        AtlasEntityDef entityDef = new AtlasEntityDef("emptyEntityDef");
        String jsonString = AtlasType.toJson((Object)entityDef);
        AtlasEntityDef entityDef2 = (AtlasEntityDef)AtlasType.fromJson((String)jsonString, AtlasEntityDef.class);
        Assert.assertEquals((Object)entityDef2, (Object)entityDef, (String)"Incorrect serialization/deserialization of AtlasEntityDef");
    }

    @Test
    public void testEntityDefSerDe() {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDef();
        String jsonString = AtlasType.toJson((Object)entityDef);
        AtlasEntityDef entityDef2 = (AtlasEntityDef)AtlasType.fromJson((String)jsonString, AtlasEntityDef.class);
        Assert.assertEquals((Object)entityDef2, (Object)entityDef, (String)"Incorrect serialization/deserialization of AtlasEntityDef");
    }

    @Test
    public void testEntityDefSerDeWithSuperType() {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDefWithSuperType();
        String jsonString = AtlasType.toJson((Object)entityDef);
        AtlasEntityDef entityDef2 = (AtlasEntityDef)AtlasType.fromJson((String)jsonString, AtlasEntityDef.class);
        Assert.assertEquals((Object)entityDef2, (Object)entityDef, (String)"Incorrect serialization/deserialization of AtlasEntityDef with superType");
    }

    @Test
    public void testEntityDefSerDeWithSuperTypes() {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDefWithSuperTypes();
        String jsonString = AtlasType.toJson((Object)entityDef);
        AtlasEntityDef entityDef2 = (AtlasEntityDef)AtlasType.fromJson((String)jsonString, AtlasEntityDef.class);
        Assert.assertEquals((Object)entityDef2, (Object)entityDef, (String)"Incorrect serialization/deserialization of AtlasEntityDef with superTypes");
    }

    @Test
    public void testEntityDefAddSuperType() {
        AtlasEntityDef entityDef = ModelTestUtil.newEntityDef();
        String newSuperType = "newType-abcd-1234";
        entityDef.addSuperType(newSuperType);
        Assert.assertTrue((boolean)entityDef.hasSuperType(newSuperType));
        entityDef.removeSuperType(newSuperType);
    }

    @Test
    public void testEntityDefRemoveElement() {
        AtlasEntityDef entityDef = ModelTestUtil.newEntityDefWithSuperTypes();
        for (String superType : entityDef.getSuperTypes()) {
            entityDef.removeSuperType(superType);
            Assert.assertFalse((boolean)entityDef.hasSuperType(superType));
        }
    }

    @Test
    public void testEntityDefSetSuperTypes() {
        AtlasEntityDef entityDef = ModelTestUtil.newEntityDefWithSuperTypes();
        Set oldSuperTypes = entityDef.getSuperTypes();
        HashSet<String> newSuperTypes = new HashSet<String>();
        newSuperTypes.add("newType-abcd-1234");
        entityDef.setSuperTypes(newSuperTypes);
        for (String superType : oldSuperTypes) {
            Assert.assertFalse((boolean)entityDef.hasSuperType(superType));
        }
        for (String superType : newSuperTypes) {
            Assert.assertTrue((boolean)entityDef.hasSuperType(superType));
        }
        entityDef.setSuperTypes(oldSuperTypes);
    }

    @Test
    public void testEntityDefHasSuperTypeWithNoSuperType() {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDef();
        for (String superType : entityDef.getSuperTypes()) {
            Assert.assertTrue((boolean)entityDef.hasSuperType(superType));
        }
        Assert.assertFalse((boolean)entityDef.hasSuperType("01234-xyzabc-;''-)("));
    }

    @Test
    public void testEntityDefHasSuperTypeWithNoSuperTypes() {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDefWithSuperTypes();
        for (String superType : entityDef.getSuperTypes()) {
            Assert.assertTrue((boolean)entityDef.hasSuperType(superType));
        }
        Assert.assertFalse((boolean)entityDef.hasSuperType("01234-xyzabc-;''-)("));
    }
}

