/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasEntity {
    @Test
    public void testEntitySerDe() throws AtlasBaseException {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDef();
        AtlasTypeRegistry typeRegistry = ModelTestUtil.getTypesRegistry();
        AtlasEntityType entityType = typeRegistry.getEntityTypeByName(entityDef.getName());
        Assert.assertNotNull((Object)entityType);
        AtlasEntity ent1 = entityType.createDefaultValue();
        String jsonString = AtlasType.toJson((Object)ent1);
        AtlasEntity ent2 = (AtlasEntity)AtlasType.fromJson((String)jsonString, AtlasEntity.class);
        entityType.normalizeAttributeValues(ent2);
        Assert.assertEquals((Object)ent2, (Object)ent1, (String)"Incorrect serialization/deserialization of AtlasEntity");
    }

    @Test
    public void testEntitySerDeWithSuperType() throws AtlasBaseException {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDefWithSuperType();
        AtlasTypeRegistry typeRegistry = ModelTestUtil.getTypesRegistry();
        AtlasEntityType entityType = typeRegistry.getEntityTypeByName(entityDef.getName());
        Assert.assertNotNull((Object)entityType);
        AtlasEntity ent1 = entityType.createDefaultValue();
        String jsonString = AtlasType.toJson((Object)ent1);
        AtlasEntity ent2 = (AtlasEntity)AtlasType.fromJson((String)jsonString, AtlasEntity.class);
        entityType.normalizeAttributeValues(ent2);
        Assert.assertEquals((Object)ent2, (Object)ent1, (String)"Incorrect serialization/deserialization of AtlasEntity with superType");
    }

    @Test
    public void testEntitySerDeWithSuperTypes() throws AtlasBaseException {
        AtlasEntityDef entityDef = ModelTestUtil.getEntityDefWithSuperTypes();
        AtlasTypeRegistry typeRegistry = ModelTestUtil.getTypesRegistry();
        AtlasEntityType entityType = typeRegistry.getEntityTypeByName(entityDef.getName());
        Assert.assertNotNull((Object)entityType);
        AtlasEntity ent1 = entityType.createDefaultValue();
        String jsonString = AtlasType.toJson((Object)ent1);
        AtlasEntity ent2 = (AtlasEntity)AtlasType.fromJson((String)jsonString, AtlasEntity.class);
        entityType.normalizeAttributeValues(ent2);
        Assert.assertEquals((Object)ent2, (Object)ent1, (String)"Incorrect serialization/deserialization of AtlasEntity with superTypes");
    }
}

