/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AttributeTransform;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TransformationHandlerTest {
    private static final Logger LOG = LoggerFactory.getLogger(TransformationHandlerTest.class);
    private static final String TYPENAME_REFERENCEABLE = "Referenceable";
    private static final String TYPENAME_ASSET = "Asset";
    private static final String TYPENAME_NON_ASSET = "non_asset";
    private static final String[] CLUSTER_NAMES = new String[]{"cl1", "prod"};
    private static final String[] DATABASE_NAMES = new String[]{"hr", "sales", "engg"};
    private static final String[] TABLE_NAMES = new String[]{"employees", "products", "invoice"};
    private static final String[] COLUMN_NAMES = new String[]{"name", "age", "dob"};

    @Test
    public void testHdfsClusterRenameHandler() {
        AttributeTransform p1 = new AttributeTransform(Collections.singletonMap("hdfs_path.clusterName", "EQUALS: cl1"), Collections.singletonMap("hdfs_path.clusterName", "SET: cl2"));
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p1));
        for (AtlasEntity hdfsPath : this.getHdfsPathEntities()) {
            String qualifiedName = (String)hdfsPath.getAttribute("qualifiedName");
            boolean endsWithCl1 = qualifiedName.endsWith("@cl1");
            this.applyTransforms(hdfsPath, handlers);
            String transformedValue = (String)hdfsPath.getAttribute("qualifiedName");
            if (endsWithCl1) {
                Assert.assertTrue((boolean)transformedValue.endsWith("@cl2"), (String)(transformedValue + ": expected to end with @cl2"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)transformedValue, (String)"not expected to change");
        }
    }

    @Test
    public void testHdfsClusterNameToggleCaseHandler() {
        AttributeTransform p1 = new AttributeTransform(Collections.singletonMap("hdfs_path.clusterName", "EQUALS: cl1"), Collections.singletonMap("hdfs_path.clusterName", "TO_UPPER:"));
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p1));
        List<AtlasEntity> hdfsPaths = this.getHdfsPathEntities();
        for (AtlasEntity hdfsPath : hdfsPaths) {
            String qualifiedName = (String)hdfsPath.getAttribute("qualifiedName");
            boolean endsWithCl1 = qualifiedName.endsWith("@cl1");
            this.applyTransforms(hdfsPath, handlers);
            String transformedValue = (String)hdfsPath.getAttribute("qualifiedName");
            if (endsWithCl1) {
                Assert.assertTrue((boolean)transformedValue.endsWith("@CL1"), (String)(transformedValue + ": expected to end with @CL1"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)transformedValue, (String)"not expected to change");
        }
        AttributeTransform p2 = new AttributeTransform(Collections.singletonMap("hdfs_path.clusterName", "EQUALS: CL1"), Collections.singletonMap("hdfs_path.clusterName", "TO_LOWER:"));
        handlers = this.initializeHandlers(Collections.singletonList(p2));
        for (AtlasEntity hdfsPath : hdfsPaths) {
            String qualifiedName = (String)hdfsPath.getAttribute("qualifiedName");
            boolean endsWithCL1 = qualifiedName.endsWith("@CL1");
            this.applyTransforms(hdfsPath, handlers);
            String transformedValue = (String)hdfsPath.getAttribute("qualifiedName");
            if (endsWithCL1) {
                Assert.assertTrue((boolean)transformedValue.endsWith("@cl1"), (String)(transformedValue + ": expected to end with @cl1"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)transformedValue, (String)"not expected to change");
        }
    }

    @Test
    public void testHiveTableClearAttributeHandler() {
        AttributeTransform p1 = new AttributeTransform(Collections.singletonMap("hive_table.replicatedTo", "HAS_VALUE:"), Collections.singletonMap("hive_table.replicatedTo", "CLEAR:"));
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p1));
        List<AtlasEntity> entities = this.getAllEntities();
        for (AtlasEntity entity : entities) {
            String replicatedTo = (String)entity.getAttribute("replicatedTo");
            if (entity.getTypeName() == "hive_table") {
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)replicatedTo));
            }
            this.applyTransforms(entity, handlers);
            String transformedValue = (String)entity.getAttribute("replicatedTo");
            if (entity.getTypeName() != "hive_table") continue;
            Assert.assertTrue((boolean)StringUtils.isEmpty((String)transformedValue));
        }
    }

    @Test
    public void testEntityClearAttributesActionWithNoCondition() {
        HashMap<String, String> actions = new HashMap<String, String>(){
            {
                this.put("Referenceable.replicatedTo", "CLEAR:");
                this.put("Referenceable.replicatedFrom", "CLEAR:");
            }
        };
        AttributeTransform transform = new AttributeTransform(null, (Map)actions);
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(transform));
        List<AtlasEntity> entities = this.getAllEntities();
        for (AtlasEntity entity : entities) {
            String replicatedTo = (String)entity.getAttribute("replicatedTo");
            String replicatedFrom = (String)entity.getAttribute("replicatedFrom");
            if (entity.getTypeName() == "hive_table") {
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)replicatedTo));
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)replicatedFrom));
            }
            this.applyTransforms(entity, handlers);
            replicatedTo = (String)entity.getAttribute("replicatedTo");
            replicatedFrom = (String)entity.getAttribute("replicatedFrom");
            if (entity.getTypeName() != "hive_table") continue;
            Assert.assertTrue((boolean)StringUtils.isEmpty((String)replicatedTo));
            Assert.assertTrue((boolean)StringUtils.isEmpty((String)replicatedFrom));
        }
    }

    @Test
    public void testEntityClearAttributesActionWithNoTypeNameAndNoCondition() {
        HashMap<String, String> actions = new HashMap<String, String>(){
            {
                this.put("replicatedTo", "CLEAR:");
                this.put("replicatedFrom", "CLEAR:");
            }
        };
        AttributeTransform transform = new AttributeTransform(null, (Map)actions);
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(transform));
        List<AtlasEntity> entities = this.getAllEntities();
        for (AtlasEntity entity : entities) {
            String replicatedTo = (String)entity.getAttribute("replicatedTo");
            String replicatedFrom = (String)entity.getAttribute("replicatedFrom");
            if (entity.getTypeName() == "hive_table") {
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)replicatedTo));
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)replicatedFrom));
            }
            this.applyTransforms(entity, handlers);
            replicatedTo = (String)entity.getAttribute("replicatedTo");
            replicatedFrom = (String)entity.getAttribute("replicatedFrom");
            if (entity.getTypeName() != "hive_table") continue;
            Assert.assertTrue((boolean)StringUtils.isEmpty((String)replicatedTo));
            Assert.assertTrue((boolean)StringUtils.isEmpty((String)replicatedFrom));
        }
    }

    @Test
    public void testHdfsPathNameReplacePrefixHandler() {
        AttributeTransform p1 = new AttributeTransform(Collections.singletonMap("hdfs_path.name", "STARTS_WITH: /aa/bb/"), Collections.singletonMap("hdfs_path.name", "REPLACE_PREFIX: = :/aa/bb/=/xx/yy/"));
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p1));
        for (AtlasEntity hdfsPath : this.getHdfsPathEntities()) {
            String name = (String)hdfsPath.getAttribute("name");
            boolean startsWith_aa_bb_ = name.startsWith("/aa/bb/");
            this.applyTransforms(hdfsPath, handlers);
            String transformedValue = (String)hdfsPath.getAttribute("name");
            if (startsWith_aa_bb_) {
                Assert.assertTrue((boolean)transformedValue.startsWith("/xx/yy/"), (String)(transformedValue + ": expected to start with /xx/yy/"));
                continue;
            }
            Assert.assertEquals((String)name, (String)transformedValue, (String)"not expected to change");
        }
    }

    @Test
    public void testHiveDatabaseClusterRenameHandler() {
        AttributeTransform p1 = new AttributeTransform(Collections.singletonMap("hive_db.clusterName", "EQUALS: cl1"), Collections.singletonMap("hive_db.clusterName", "SET: cl1_backup"));
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p1));
        for (AtlasEntity entity : this.getAllEntities()) {
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            boolean isHdfsPath = StringUtils.equals((String)entity.getTypeName(), (String)"hdfs_path");
            boolean endsWithCl1 = qualifiedName.endsWith("@cl1");
            boolean containsCl1 = qualifiedName.contains("@cl1");
            this.applyTransforms(entity, handlers);
            String transformedValue = (String)entity.getAttribute("qualifiedName");
            if (!isHdfsPath && endsWithCl1) {
                Assert.assertTrue((boolean)transformedValue.endsWith("@cl1_backup"), (String)(transformedValue + ": expected to end with @cl1_backup"));
                continue;
            }
            if (!isHdfsPath && containsCl1) {
                Assert.assertTrue((boolean)transformedValue.contains("@cl1_backup"), (String)(transformedValue + ": expected to contains @cl1_backup"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)transformedValue, (String)"not expected to change");
        }
    }

    @Test
    public void testHiveDatabaseNameRenameHandler() {
        AttributeTransform p = new AttributeTransform(Collections.singletonMap("hive_db.name", "EQUALS: hr"), Collections.singletonMap("hive_db.name", "SET: hr_backup"));
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p));
        for (AtlasEntity entity : this.getAllEntities()) {
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            boolean startsWithHrDot = qualifiedName.startsWith("hr.");
            boolean startsWithHrAt = qualifiedName.startsWith("hr@");
            this.applyTransforms(entity, handlers);
            if (startsWithHrDot) {
                Assert.assertTrue((boolean)((String)entity.getAttribute("qualifiedName")).startsWith("hr_backup."));
                continue;
            }
            if (startsWithHrAt) {
                Assert.assertTrue((boolean)((String)entity.getAttribute("qualifiedName")).startsWith("hr_backup@"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)((String)entity.getAttribute("qualifiedName")), (String)"not expected to change");
        }
    }

    @Test
    public void testHiveTableNameRenameHandler() {
        AttributeTransform p = new AttributeTransform();
        p.addCondition("hive_db.name", "EQUALS: hr");
        p.addCondition("hive_table.name", "EQUALS: employees");
        p.addAction("hive_table.name", "SET: employees_backup");
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p));
        for (AtlasEntity entity : this.getAllEntities()) {
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            boolean startsWithHrEmployeesDot = qualifiedName.startsWith("hr.employees.");
            boolean startsWithHrEmployeesAt = qualifiedName.startsWith("hr.employees@");
            this.applyTransforms(entity, handlers);
            if (startsWithHrEmployeesDot) {
                Assert.assertTrue((boolean)((String)entity.getAttribute("qualifiedName")).startsWith("hr.employees_backup."));
                continue;
            }
            if (startsWithHrEmployeesAt) {
                Assert.assertTrue((boolean)((String)entity.getAttribute("qualifiedName")).startsWith("hr.employees_backup@"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)((String)entity.getAttribute("qualifiedName")), (String)"not expected to change");
        }
    }

    @Test
    public void testHiveColumnNameRenameHandler() {
        AttributeTransform p = new AttributeTransform();
        p.addCondition("hive_db.name", "EQUALS: hr");
        p.addCondition("hive_table.name", "EQUALS: employees");
        p.addCondition("hive_column.name", "EQUALS: age");
        p.addAction("hive_column.name", "SET: age_backup");
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p));
        for (AtlasEntity entity : this.getAllEntities()) {
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            boolean startsWithHrEmployeesAgeAt = qualifiedName.startsWith("hr.employees.age@");
            this.applyTransforms(entity, handlers);
            if (startsWithHrEmployeesAgeAt) {
                Assert.assertTrue((boolean)((String)entity.getAttribute("qualifiedName")).startsWith("hr.employees.age_backup@"));
                continue;
            }
            Assert.assertEquals((String)qualifiedName, (String)((String)entity.getAttribute("qualifiedName")), (String)"not expected to change");
        }
    }

    @Test
    public void verifyAddClassification() {
        AtlasEntityTransformer transformer = new AtlasEntityTransformer(Collections.singletonMap("hive_db.qualifiedName", "EQUALS: hr@cl1"), Collections.singletonMap("Referenceable.", "ADD_CLASSIFICATION: replicated"), this.getTransformerContext());
        List<BaseEntityHandler> handlers = Collections.singletonList(new BaseEntityHandler(Collections.singletonList(transformer)));
        this.assertApplyTransform(handlers);
    }

    @Test
    public void verifyAddClassificationUsingScope() {
        AtlasExportRequest exportRequest = new AtlasExportRequest();
        exportRequest.setItemsToExport(Collections.singletonList(new AtlasObjectId("hive_db", Collections.singletonMap("qualifiedName", "hr@cl1"))));
        AtlasEntityTransformer transformer = new AtlasEntityTransformer(Collections.singletonMap("Referenceable.", "topLevel: "), Collections.singletonMap(TYPENAME_REFERENCEABLE, "ADD_CLASSIFICATION: replicated"), new TransformerContext(this.getTypeRegistry(), null, exportRequest));
        List<BaseEntityHandler> handlers = Collections.singletonList(new BaseEntityHandler(Collections.singletonList(transformer)));
        this.assertApplyTransform(handlers);
    }

    @Test
    public void verifyEntityTypeInAttributeName() {
        AttributeTransform p = new AttributeTransform();
        p.addAction("Asset.name", "SET: renamed");
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p));
        AtlasEntity assetEntity = new AtlasEntity(TYPENAME_ASSET, "name", (Object)"originalName");
        AtlasEntity assetSubEntity = new AtlasEntity("hive_db", "name", (Object)"originalName");
        AtlasEntity nonAssetEntity = new AtlasEntity(TYPENAME_NON_ASSET, "name", (Object)"originalName");
        this.applyTransforms(assetEntity, handlers);
        this.applyTransforms(assetSubEntity, handlers);
        this.applyTransforms(nonAssetEntity, handlers);
        Assert.assertEquals((String)((String)assetEntity.getAttribute("name")), (String)"renamed", (String)"Asset.name expected to be updated for Asset entity");
        Assert.assertEquals((String)((String)assetSubEntity.getAttribute("name")), (String)"renamed", (String)"Asset.name expected to be updated for Asset sub-type entity");
        Assert.assertEquals((String)((String)nonAssetEntity.getAttribute("name")), (String)"originalName", (String)"Asset.name expected to be not updated for non-Asset type entity");
    }

    @Test
    public void verifyNoEntityTypeInAttributeName() {
        AttributeTransform p = new AttributeTransform();
        p.addAction("name", "SET: renamed");
        List<BaseEntityHandler> handlers = this.initializeHandlers(Collections.singletonList(p));
        AtlasEntity assetEntity = new AtlasEntity(TYPENAME_ASSET, "name", (Object)"originalName");
        AtlasEntity assetSubEntity = new AtlasEntity("hive_db", "name", (Object)"originalName");
        AtlasEntity nonAssetEntity = new AtlasEntity(TYPENAME_NON_ASSET, "name", (Object)"originalName");
        this.applyTransforms(assetEntity, handlers);
        this.applyTransforms(assetSubEntity, handlers);
        this.applyTransforms(nonAssetEntity, handlers);
        Assert.assertEquals((String)((String)assetEntity.getAttribute("name")), (String)"renamed", (String)"name expected to be updated for Asset entity");
        Assert.assertEquals((String)((String)assetSubEntity.getAttribute("name")), (String)"renamed", (String)"name expected to be updated for Asset sub-type entity");
        Assert.assertEquals((String)((String)nonAssetEntity.getAttribute("name")), (String)"renamed", (String)"name expected to be not updated for non-Asset type entity");
    }

    private void assertApplyTransform(List<BaseEntityHandler> handlers) {
        for (AtlasEntity entity : this.getAllEntities()) {
            this.applyTransforms(entity, handlers);
            if (entity.getTypeName().equals("hive_db") && entity.getAttribute("qualifiedName").equals("hr@cl1")) {
                Assert.assertNotNull((Object)entity.getClassifications());
                continue;
            }
            Assert.assertNull((Object)entity.getClassifications());
        }
    }

    private List<BaseEntityHandler> initializeHandlers(List<AttributeTransform> params) {
        return BaseEntityHandler.createEntityHandlers(params, (TransformerContext)this.getTransformerContext());
    }

    private void applyTransforms(AtlasEntity entity, List<BaseEntityHandler> handlers) {
        for (BaseEntityHandler handler : handlers) {
            handler.transform(entity);
        }
    }

    private TransformerContext getTransformerContext() {
        return new TransformerContext(this.getTypeRegistry(), null, null);
    }

    private AtlasTypeRegistry getTypeRegistry() {
        AtlasTypeRegistry ret = new AtlasTypeRegistry();
        AtlasEntityDef defReferenceable = new AtlasEntityDef(TYPENAME_REFERENCEABLE);
        AtlasEntityDef defAsset = new AtlasEntityDef(TYPENAME_ASSET);
        AtlasEntityDef defHdfsPath = new AtlasEntityDef("hdfs_path");
        AtlasEntityDef defHiveDb = new AtlasEntityDef("hive_db");
        AtlasEntityDef defHiveTable = new AtlasEntityDef("hive_table");
        AtlasEntityDef defHiveColumn = new AtlasEntityDef("hive_column");
        AtlasEntityDef defHiveStorDesc = new AtlasEntityDef("hive_storagedesc");
        AtlasEntityDef defNonAsset = new AtlasEntityDef(TYPENAME_NON_ASSET);
        defAsset.addSuperType(TYPENAME_REFERENCEABLE);
        defHdfsPath.addSuperType(TYPENAME_ASSET);
        defHiveDb.addSuperType(TYPENAME_ASSET);
        defHiveTable.addSuperType(TYPENAME_ASSET);
        defHiveColumn.addSuperType(TYPENAME_ASSET);
        defNonAsset.addSuperType(TYPENAME_REFERENCEABLE);
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.setEntityDefs(Arrays.asList(defReferenceable, defAsset, defHdfsPath, defHiveDb, defHiveTable, defHiveColumn, defHiveStorDesc, defNonAsset));
        try {
            AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = ret.lockTypeRegistryForUpdate();
            ttr.addTypes(typesDef);
            ret.releaseTypeRegistryForUpdate(ttr, true);
        }
        catch (AtlasBaseException excp) {
            LOG.warn("failed to initialize type-registry", (Throwable)excp);
        }
        return ret;
    }

    private List<AtlasEntity> getHdfsPathEntities() {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        for (String clusterName : CLUSTER_NAMES) {
            ret.add(this.getHdfsPathEntity1(clusterName));
            ret.add(this.getHdfsPathEntity2(clusterName));
        }
        return ret;
    }

    private List<AtlasEntity> getAllEntities() {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        for (String clusterName : CLUSTER_NAMES) {
            ret.add(this.getHdfsPathEntity1(clusterName));
            ret.add(this.getHdfsPathEntity2(clusterName));
            for (String databaseName : DATABASE_NAMES) {
                ret.add(this.getHiveDbEntity(clusterName, databaseName));
                for (String tableName : TABLE_NAMES) {
                    ret.add(this.getHiveTableEntity(clusterName, databaseName, tableName));
                    ret.add(this.getHiveStorageDescriptorEntity(clusterName, databaseName, tableName));
                    for (String columnName : COLUMN_NAMES) {
                        ret.add(this.getHiveColumnEntity(clusterName, databaseName, tableName, columnName));
                    }
                }
            }
        }
        return ret;
    }

    private AtlasEntity getHdfsPathEntity1(String clusterName) {
        AtlasEntity entity = new AtlasEntity("hdfs_path");
        entity.setAttribute("name", (Object)"/aa/bb/employee");
        entity.setAttribute("path", (Object)"hdfs://localhost.localdomain:8020/aa/bb/employee");
        entity.setAttribute("qualifiedName", (Object)("hdfs://localhost.localdomain:8020/aa/bb/employee@" + clusterName));
        entity.setAttribute("clusterName", (Object)clusterName);
        entity.setAttribute("isSymlink", (Object)false);
        entity.setAttribute("modifiedTime", (Object)0);
        entity.setAttribute("isFile", (Object)false);
        entity.setAttribute("numberOfReplicas", (Object)0);
        entity.setAttribute("createTime", (Object)0);
        entity.setAttribute("fileSize", (Object)0);
        return entity;
    }

    private AtlasEntity getHdfsPathEntity2(String clusterName) {
        AtlasEntity entity = new AtlasEntity("hdfs_path");
        entity.setAttribute("name", (Object)"/cc/dd/employee");
        entity.setAttribute("path", (Object)"hdfs://localhost.localdomain:8020/cc/dd/employee");
        entity.setAttribute("qualifiedName", (Object)("hdfs://localhost.localdomain:8020/cc/dd/employee@" + clusterName));
        entity.setAttribute("clusterName", (Object)clusterName);
        entity.setAttribute("isSymlink", (Object)false);
        entity.setAttribute("modifiedTime", (Object)0);
        entity.setAttribute("isFile", (Object)false);
        entity.setAttribute("numberOfReplicas", (Object)0);
        entity.setAttribute("createTime", (Object)0);
        entity.setAttribute("fileSize", (Object)0);
        return entity;
    }

    private AtlasEntity getHiveDbEntity(String clusterName, String dbName) {
        AtlasEntity entity = new AtlasEntity("hive_db");
        entity.setAttribute("name", (Object)dbName);
        entity.setAttribute("qualifiedName", (Object)(dbName + "@" + clusterName));
        entity.setAttribute("location", (Object)("hdfs://localhost.localdomain:8020/warehouse/tablespace/managed/hive/" + dbName + ".db"));
        entity.setAttribute("clusterName", (Object)clusterName);
        entity.setAttribute("owner", (Object)"hive");
        entity.setAttribute("ownerType", (Object)"USER");
        return entity;
    }

    private AtlasEntity getHiveTableEntity(String clusterName, String dbName, String tableName) {
        String qualifiedName = dbName + "." + tableName + "@" + clusterName;
        AtlasEntity entity = new AtlasEntity("hive_table");
        entity.setAttribute("name", (Object)tableName);
        entity.setAttribute("qualifiedName", (Object)qualifiedName);
        entity.setAttribute("owner", (Object)"hive");
        entity.setAttribute("temporary", (Object)false);
        entity.setAttribute("lastAccessTime", (Object)"1535656355000");
        entity.setAttribute("tableType", (Object)"EXTERNAL_TABLE");
        entity.setAttribute("createTime", (Object)"1535656355000");
        entity.setAttribute("retention", (Object)0);
        entity.setAttribute("replicatedTo", (Object)"[{\"guid\":\"f378cfa5-c4aa-4699-a733-8f11d2f089cd\",\"typeName\":\"AtlasServer\"},{\"guid\":\"58e42789-ea3e-4eaa-a0c4-d38d8632e548\",\"typeName\":\"AtlasServer\"}]");
        entity.setAttribute("replicatedFrom", (Object)"[{\"guid\":\"f378cfa5-c4aa-4699-a733-8f11d2f089cd\",\"typeName\":\"AtlasServer\"},{\"guid\":\"58e42789-ea3e-4eaa-a0c4-d38d8632e548\",\"typeName\":\"AtlasServer\"}]");
        return entity;
    }

    private AtlasEntity getHiveStorageDescriptorEntity(String clusterName, String dbName, String tableName) {
        String qualifiedName = "hdfs://localhost.localdomain:8020/warehouse/tablespace/managed/hive/" + dbName + ".db/" + tableName;
        AtlasEntity entity = new AtlasEntity("hive_storagedesc");
        entity.setAttribute("qualifiedName", (Object)(dbName + "." + tableName + "@" + clusterName + "_storage"));
        entity.setAttribute("storedAsSubDirectories", (Object)false);
        entity.setAttribute("location", (Object)qualifiedName);
        entity.setAttribute("compressed", (Object)false);
        entity.setAttribute("inputFormat", (Object)"org.apache.hadoop.mapred.TextInputFormat");
        entity.setAttribute("outputFormat", (Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
        entity.setAttribute("numBuckets", (Object)-1);
        return entity;
    }

    private AtlasEntity getHiveColumnEntity(String clusterName, String dbName, String tableName, String columnName) {
        String qualifiedName = dbName + "." + tableName + "." + columnName + "@" + clusterName;
        AtlasEntity entity = new AtlasEntity("hive_column");
        entity.setAttribute("owner", (Object)"hive");
        entity.setAttribute("qualifiedName", (Object)qualifiedName);
        entity.setAttribute("name", (Object)columnName);
        entity.setAttribute("position", (Object)1);
        entity.setAttribute("type", (Object)"string");
        return entity;
    }

    private AtlasEntity getNonAssetEntity() {
        return new AtlasEntity(TYPENAME_NON_ASSET);
    }
}

