define([ "require", "hbs!tmpl/site/Header", "utils/CommonViewFunction", "utils/Globals", "utils/Utils" ], function(require, tmpl, CommonViewFunction, Globals, Utils) {
    "use strict";
    var Header = Marionette.LayoutView.extend({
        template: tmpl,
        regions: {},
        ui: {
            backButton: "[data-id='backButton']",
            menuHamburger: "[data-id='menuHamburger']"
        },
        events: function() {
            var events = {};
            return events["click " + this.ui.backButton] = function() {
                var queryParams = Utils.getUrlState.getQueryParams(), urlPath = "searchUrl";
                queryParams && queryParams.from && ("classification" == queryParams.from ? urlPath = "tagUrl" : "glossary" == queryParams.from && (urlPath = "glossaryUrl")), 
                Utils.setUrl({
                    url: Globals.saveApplicationState.tabState[urlPath],
                    mergeBrowserUrl: !1,
                    trigger: !0,
                    updateTabState: !0
                });
            }, events["click " + this.ui.menuHamburger] = function() {
                $("body").toggleClass("full-screen");
            }, events;
        },
        initialize: function(options) {},
        onRender: function() {
            var that = this;
            Globals.userLogedIn.status && that.$(".userName").html(Globals.userLogedIn.response.userName);
        }
    });
    return Header;
});