define([ "require", "backbone", "hbs!tmpl/graph/LineageLayoutView_tmpl", "collection/VLineageList", "models/VEntity", "utils/Utils", "dagreD3", "d3-tip", "utils/Enums", "utils/UrlLinks", "platform" ], function(require, Backbone, LineageLayoutViewtmpl, VLineageList, VEntity, Utils, dagreD3, d3Tip, Enums, UrlLinks, platform) {
    "use strict";
    var LineageLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "LineageLayoutView",
        template: LineageLayoutViewtmpl,
        regions: {},
        ui: {
            graph: ".graph"
        },
        events: function() {
            var events = {};
            return events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "guid", "entityDefCollection", "actionCallBack", "fetchCollection")), 
            this.collection = new VLineageList(), this.lineageData = null, this.typeMap = {}, 
            this.apiGuid = {}, this.asyncFetchCounter = 0, this.edgeCall;
        },
        onRender: function() {
            this.$(".fontLoader").show(), this.fetchGraphData(), "IE" === platform.name && this.$("svg").css("opacity", "0"), 
            this.layoutRendered && this.layoutRendered(), this.g = new dagreD3.graphlib.Graph().setGraph({
                nodesep: 50,
                ranksep: 90,
                rankdir: "LR",
                marginx: 20,
                marginy: 20,
                transition: function(selection) {
                    return selection.transition().duration(500);
                }
            }).setDefaultEdgeLabel(function() {
                return {};
            });
        },
        fetchGraphData: function() {
            var that = this;
            this.fromToObj = {}, this.collection.getLineage(this.guid, {
                skipDefaultError: !0,
                success: function(data) {
                    data.relations.length ? (that.lineageData = data, that.generateData(data.relations, data.guidEntityMap)) : that.noLineage();
                },
                cust_error: function(model, response) {
                    that.lineageData = [], that.noLineage();
                }
            });
        },
        noLineage: function() {
            this.$(".fontLoader").hide(), this.$("svg").html('<text x="50%" y="50%" alignment-baseline="middle" text-anchor="middle">No lineage data found</text>'), 
            this.actionCallBack && this.actionCallBack();
        },
        generateData: function(relations, guidEntityMap) {
            function makeNodeObj(relationObj) {
                var obj = {};
                obj.shape = "img", obj.typeName = relationObj.typeName, obj.label = relationObj.displayText.trunc(18), 
                obj.toolTipLabel = relationObj.displayText, obj.id = relationObj.guid, obj.isLineage = !0, 
                obj.queryText = relationObj.queryText, relationObj.status && (obj.status = relationObj.status);
                var entityDef = that.entityDefCollection.fullCollection.find({
                    name: relationObj.typeName
                });
                return entityDef && entityDef.get("superTypes") && (obj.isProcess = !!_.contains(entityDef.get("superTypes"), "Process")), 
                obj;
            }
            var that = this;
            _.each(relations, function(obj, index) {
                that.fromToObj[obj.fromEntityId] || (that.fromToObj[obj.fromEntityId] = makeNodeObj(guidEntityMap[obj.fromEntityId]), 
                that.g.setNode(obj.fromEntityId, that.fromToObj[obj.fromEntityId])), that.fromToObj[obj.toEntityId] || (that.fromToObj[obj.toEntityId] = makeNodeObj(guidEntityMap[obj.toEntityId]), 
                that.g.setNode(obj.toEntityId, that.fromToObj[obj.toEntityId]));
                var styleObj = {
                    fill: "none",
                    stroke: "#8bc152",
                    width: 2
                };
                that.g.setEdge(obj.fromEntityId, obj.toEntityId, {
                    arrowhead: "arrowPoint",
                    lineInterpolate: "basis",
                    style: "fill:" + styleObj.fill + ";stroke:" + styleObj.stroke + ";stroke-width:" + styleObj.width,
                    styleObj: styleObj
                });
            }), this.fromToObj[this.guid] && (this.fromToObj[this.guid].isLineage = !1, this.checkForLineageOrImpactFlag(relations, this.guid)), 
            0 == this.asyncFetchCounter && this.createGraph();
        },
        checkForLineageOrImpactFlag: function(relations, guid) {
            var that = this, nodeFound = _.where(relations, {
                fromEntityId: guid
            });
            nodeFound.length && _.each(nodeFound, function(node) {
                if (!node.traversed) {
                    node.traversed = !0, that.fromToObj[node.toEntityId].isLineage = !1;
                    var styleObj = {
                        fill: "none",
                        stroke: "#fb4200",
                        width: 2
                    };
                    that.g.setEdge(node.fromEntityId, node.toEntityId, {
                        arrowhead: "arrowPoint",
                        lineInterpolate: "basis",
                        style: "fill:" + styleObj.fill + ";stroke:" + styleObj.stroke + ";stroke-width:" + styleObj.width,
                        styleObj: styleObj
                    }), that.checkForLineageOrImpactFlag(relations, node.toEntityId);
                }
            });
        },
        toggleInformationSlider: function(options) {
            options.open && !this.$(".lineage-edge-details").hasClass("open") ? this.$(".lineage-edge-details").addClass("open") : options.close && this.$(".lineage-edge-details").hasClass("open") && (d3.selectAll("circle").attr("stroke", "none"), 
            this.$(".lineage-edge-details").removeClass("open"));
        },
        setGraphZoomPositionCal: function(argument) {
            var initialScale = 1.2, svgEl = this.$("svg"), scaleEl = this.$("svg").find(">g"), translateValue = [ (this.$("svg").width() - this.g.graph().width * initialScale) / 2, (this.$("svg").height() - this.g.graph().height * initialScale) / 2 ];
            _.keys(this.g._nodes).length > 15 && (initialScale = 0, this.$("svg").addClass("noScale")), 
            svgEl.parents(".panel.panel-fullscreen").length ? (translateValue = [ 20, 20 ], 
            svgEl.hasClass("noScale") && (scaleEl.hasClass("scaleLinage") ? (scaleEl.removeClass("scaleLinage"), 
            initialScale = 0) : (scaleEl.addClass("scaleLinage"), initialScale = 1.2))) : scaleEl.removeClass("scaleLinage"), 
            this.zoom.translate(translateValue).scale(initialScale);
        },
        zoomed: function(that) {
            this.$("svg").find(">g").attr("transform", "translate(" + this.zoom.translate() + ")scale(" + this.zoom.scale() + ")");
        },
        createGraph: function() {
            function interpolateZoom(translate, scale) {
                return d3.transition().duration(350).tween("zoom", function() {
                    var iTranslate = d3.interpolate(zoom.translate(), translate), iScale = d3.interpolate(zoom.scale(), scale);
                    return function(t) {
                        zoom.scale(iScale(t)).translate(iTranslate(t)), that.zoomed();
                    };
                });
            }
            function zoomClick() {
                var direction = (d3.event.target, 1), factor = .2, target_zoom = 1, center = [ that.g.graph().width / 2, that.g.graph().height / 2 ], extent = zoom.scaleExtent(), translate = zoom.translate(), translate0 = [], l = [], view = {
                    x: translate[0],
                    y: translate[1],
                    k: zoom.scale()
                };
                return d3.event.preventDefault(), direction = "zoom_in" === this.id ? 1 : -1, target_zoom = zoom.scale() * (1 + factor * direction), 
                !(target_zoom < extent[0] || target_zoom > extent[1]) && (translate0 = [ (center[0] - view.x) / view.k, (center[1] - view.y) / view.k ], 
                view.k = target_zoom, l = [ translate0[0] * view.k + view.x, translate0[1] * view.k + view.y ], 
                view.x += center[0] - l[0], view.y += center[1] - l[1], void interpolateZoom([ view.x, view.y ], view.k));
            }
            var that = this, width = this.$("svg").width(), height = this.$("svg").height();
            this.g.nodes().forEach(function(v) {
                var node = that.g.node(v);
                node && (node.rx = node.ry = 5);
            });
            var render = new dagreD3.render();
            render.arrows().arrowPoint = function(parent, id, edge, type) {
                var marker = parent.append("marker").attr("id", id).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 10).attr("markerHeight", 8).attr("orient", "auto"), path = marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").style("stroke-width", 1).style("stroke-dasharray", "1,0").style("fill", edge.styleObj.stroke).style("stroke", edge.styleObj.stroke);
                dagreD3.util.applyStyle(path, edge[type + "Style"]);
            }, render.shapes().img = function(parent, bbox, node) {
                if (node.id == that.guid) var currentNode = !0;
                var shapeSvg = parent.append("circle").attr("fill", "url(#img_" + node.id + ")").attr("r", currentNode ? "15px" : "14px").attr("class", "nodeImage " + (currentNode ? "currentNode" : node.isProcess ? "blue" : "green"));
                return parent.insert("defs").append("pattern").attr("x", "0%").attr("y", "0%").attr("patternUnits", "objectBoundingBox").attr("id", "img_" + node.id).attr("width", "100%").attr("height", "100%").append("image").attr("xlink:href", function(d) {
                    if (node) return node.isProcess ? Enums.entityStateReadOnly[node.status] ? UrlLinks.apiBaseUrl + "/img/icon-gear-delete.png" : node.id == that.guid ? UrlLinks.apiBaseUrl + "/img/icon-gear-active.png" : UrlLinks.apiBaseUrl + "/img/icon-gear.png" : Enums.entityStateReadOnly[node.status] ? UrlLinks.apiBaseUrl + "/img/icon-table-delete.png" : node.id == that.guid ? UrlLinks.apiBaseUrl + "/img/icon-table-active.png" : UrlLinks.apiBaseUrl + "/img/icon-table.png";
                }).attr("x", "2").attr("y", "2").attr("width", currentNode ? "26" : "24").attr("height", currentNode ? "26" : "24"), 
                node.intersect = function(point) {
                    return dagreD3.intersect.circle(node, currentNode ? 16 : 13, point);
                }, shapeSvg;
            };
            var svg = this.svg = d3.select(this.$("svg")[0]).attr("viewBox", "0 0 " + width + " " + height).attr("enable-background", "new 0 0 " + width + " " + height), svgGroup = svg.append("g"), zoom = this.zoom = d3.behavior.zoom().scaleExtent([ .5, 6 ]).on("zoom", that.zoomed.bind(this));
            d3.selectAll(this.$("span.lineageZoomButton")).on("click", zoomClick);
            var tooltip = d3Tip().attr("class", "d3-tip").offset([ 10, 0 ]).html(function(d) {
                var value = that.g.node(d), htmlStr = "";
                return value.id !== that.guid && (htmlStr = "<h5 style='text-align: center;'>" + (value.isLineage ? "Lineage" : "Impact") + "</h5>"), 
                htmlStr += "<h5 class='text-center'><span style='color:#359f89'>" + value.toolTipLabel + "</span></h5> ", 
                value.typeName && (htmlStr += "<h5 class='text-center'><span>(" + value.typeName + ")</span></h5> "), 
                value.queryText && (htmlStr += "<h5>Query: <span style='color:#359f89'>" + value.queryText + "</span></h5> "), 
                "<div class='tip-inner-scroll'>" + htmlStr + "</div>";
            });
            svg.call(zoom).call(tooltip), "IE" !== platform.name && this.$(".fontLoader").hide(), 
            render(svgGroup, this.g), svg.on("dblclick.zoom", null).on("wheel.zoom", null), 
            svgGroup.selectAll("g.nodes g.label").attr("transform", "translate(2,-30)"), svgGroup.selectAll("g.nodes g.node").on("mouseenter", function(d) {
                that.activeNode = !0;
                this.getScreenCTM().translate(+this.getAttribute("cx"), +this.getAttribute("cy"));
                that.$("svg").find(".node").removeClass("active"), $(this).addClass("active");
                var width = $("body").width(), currentELWidth = $(this).offset(), direction = "e";
                width - currentELWidth.left < 330 ? (direction = width - currentELWidth.left < 330 && currentELWidth.top < 400 ? "sw" : "w", 
                width - currentELWidth.left < 330 && currentELWidth.top > 600 && (direction = "nw")) : currentELWidth.top > 600 ? (direction = width - currentELWidth.left < 330 && currentELWidth.top > 600 ? "nw" : "n", 
                currentELWidth.left < 50 && (direction = "ne")) : currentELWidth.top < 400 && (direction = currentELWidth.left < 50 ? "se" : "s"), 
                tooltip.direction(direction).show(d);
            }).on("dblclick", function(d) {
                tooltip.hide(d), Utils.setUrl({
                    url: "#!/detailPage/" + d + "?tabActive=lineage",
                    mergeBrowserUrl: !1,
                    trigger: !0
                });
            }).on("mouseleave", function(d) {
                that.activeNode = !1;
                var nodeEL = this;
                setTimeout(function(argument) {
                    that.activeTip || that.activeNode || ($(nodeEL).removeClass("active"), tooltip.hide(d));
                }, 400);
            }), svgGroup.selectAll("g.edgePath path.path").on("click", function(d) {
                var data = {
                    obj: _.find(that.lineageData.relations, {
                        fromEntityId: d.v,
                        toEntityId: d.w
                    })
                }, relationshipId = data.obj.relationshipId;
                require([ "views/graph/PropagationPropertyModal" ], function(PropagationPropertyModal) {
                    new PropagationPropertyModal({
                        edgeInfo: data,
                        relationshipId: relationshipId,
                        lineageData: that.lineageData,
                        apiGuid: that.apiGuid,
                        detailPageFetchCollection: that.fetchCollection
                    });
                });
            }), $("body").on("mouseover", ".d3-tip", function(el) {
                that.activeTip = !0;
            }), $("body").on("mouseleave", ".d3-tip", function(el) {
                that.activeTip = !1, that.$("svg").find(".node").removeClass("active"), tooltip.hide();
            }), this.setGraphZoomPositionCal(), zoom.event(svg), "IE" === platform.name && (this.IEGraphRenderDone = 0, 
            this.$("svg .edgePath").each(function(argument) {
                var childNode = $(this).find("marker");
                $(this).find("marker").remove();
                var eleRef = this;
                ++that.IEGraphRenderDone, setTimeout(function(argument) {
                    $(eleRef).find("defs").append(childNode), --that.IEGraphRenderDone, 0 === that.IEGraphRenderDone && (this.$(".fontLoader").hide(), 
                    this.$("svg").fadeTo(1e3, 1));
                }, 1e3);
            }));
        }
    });
    return LineageLayoutView;
});