define([ "require", "backbone", "hbs!tmpl/glossary/AssignTermLayoutView_tmpl", "utils/Utils", "utils/Enums", "utils/UrlLinks", "modules/Modal", "jquery-steps" ], function(require, Backbone, AssignTermLayoutViewTmpl, Utils, Enums, UrlLinks, Modal) {
    var AssignTermLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "AssignTermLayoutView",
        template: AssignTermLayoutViewTmpl,
        templateHelpers: function() {
            return {
                isAttributeRelationView: this.isAttributeRelationView,
                selectedTermAttributeList: Enums.termRelationAttributeList[this.selectedTermAttribute]
            };
        },
        regions: {
            RGlossaryTree: "#r_glossaryTree"
        },
        ui: {
            wizard: '[data-id="wizard"]'
        },
        events: function() {
            var events = {};
            return events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "glossaryCollection", "guid", "callback", "hideLoader", "isCategoryView", "categoryData", "isTermView", "termData", "isAttributeRelationView", "selectedTermAttribute"));
            var that = this;
            this.options = options, this.isCategoryView || this.isTermView || this.isAttributeRelationView || (this.isEntityView = !0), 
            this.glossary = {
                selectedItem: {}
            };
            var title = "";
            title = this.isCategoryView || this.isEntityView ? "Assign term to " + (this.isCategoryView ? "Category" : "entity") : this.isAttributeRelationView ? "Assign term to " + this.selectedTermAttribute : "Assign Category to term", 
            this.modal = new Modal({
                title: title,
                content: this,
                cancelText: "Cancel",
                okCloses: !1,
                okText: "Assign",
                allowCancel: !0,
                showFooter: !this.isAttributeRelationView,
                mainClass: "wizard-modal"
            }), this.modal.open(), this.modal.$el.find("button.ok").attr("disabled", !0), this.modal.on("closeModal", function() {
                that.modal.trigger("cancel"), that.assignTermError && that.hideLoader && that.hideLoader(), 
                options.onModalClose && options.onModalClose();
            }), this.modal.on("ok", function() {
                that.assignTerm();
            }), this.bindEvents();
        },
        bindEvents: function() {
            this.listenTo(this.glossaryCollection, "node_selected", function(skip) {
                this.modal.$el.find("button.ok").attr("disabled", !1);
            }, this);
        },
        onRender: function() {
            this.renderGlossaryTree();
            var that = this;
            this.isAttributeRelationView && this.ui.wizard.steps({
                headerTag: "h3",
                bodyTag: "section",
                transitionEffect: "slideLeft",
                autoFocus: !0,
                enableCancelButton: !0,
                transitionEffect: $.fn.steps.transitionEffect.none,
                transitionEffectSpeed: 200,
                labels: {
                    cancel: "Cancel",
                    finish: "Assign",
                    next: "Next",
                    previous: "Previous",
                    loading: "Loading ..."
                },
                onStepChanging: function(event, currentIndex, newIndex) {
                    var isMatch = "GlossaryTerm" == that.glossary.selectedItem.type;
                    return isMatch || Utils.notifyWarn({
                        content: "Please select Term for association"
                    }), isMatch;
                },
                onFinished: function(event, currentIndex) {
                    that.assignTerm();
                },
                onCanceled: function(event) {
                    that.modal.trigger("cancel");
                }
            });
        },
        assignTerm: function() {
            this.assignTermError = !1;
            var that = this, data = [], termAttributeFormData = [], selectedItem = this.glossary.selectedItem, selectedGuid = selectedItem.guid, ajaxOptions = {
                success: function(rModel, response) {
                    Utils.notifySuccess({
                        content: (that.isCategoryView || that.isEntityView || that.isAttributeRelationView ? "Term" : "Category") + " is associated successfully "
                    }), that.modal.trigger("closeModal"), that.callback && that.callback();
                },
                cust_error: function() {
                    that.assignTermError = !0;
                }
            }, model = new this.glossaryCollection.model();
            this.isCategoryView ? (data = $.extend(!0, {}, this.categoryData), data.terms ? data.terms.push({
                termGuid: selectedGuid
            }) : data.terms = [ {
                termGuid: selectedGuid
            } ], model.assignTermToCategory(_.extend(ajaxOptions, {
                data: JSON.stringify(data),
                guid: data.guid
            }))) : this.isTermView ? (data = $.extend(!0, {}, this.termData), data.categories ? data.categories.push({
                categoryGuid: selectedGuid
            }) : data.categories = [ {
                categoryGuid: selectedGuid
            } ], model.assignCategoryToTerm(_.extend(ajaxOptions, {
                data: JSON.stringify(data),
                guid: data.guid
            }))) : this.isAttributeRelationView ? (termAttributeFormData = this.$('[data-id="termAttributeForm"]').serializeArray().reduce(function(obj, item) {
                return obj[item.name] = item.value, obj;
            }, {}), data = $.extend(!0, {}, this.termData), data[this.selectedTermAttribute] ? data[this.selectedTermAttribute].push(_.extend({
                termGuid: selectedGuid
            }, termAttributeFormData)) : data[this.selectedTermAttribute] = [ _.extend({
                termGuid: selectedGuid
            }, termAttributeFormData) ], model.assignTermToAttributes(_.extend(ajaxOptions, {
                data: JSON.stringify(data),
                guid: data.guid
            }))) : (data.push({
                guid: that.guid
            }), model.assignTermToEntity(selectedGuid, _.extend(ajaxOptions, {
                data: JSON.stringify(data)
            })));
        },
        renderGlossaryTree: function() {
            var that = this;
            require([ "views/glossary/GlossaryLayoutView" ], function(GlossaryLayoutView) {
                that.RGlossaryTree.show(new GlossaryLayoutView(_.extend({
                    isAssignTermView: that.isCategoryView,
                    isAssignCategoryView: that.isTermView,
                    isAssignEntityView: that.isEntityView,
                    isAssignAttributeRelationView: that.isAttributeRelationView,
                    glossary: that.glossary
                }, that.options)));
            });
        }
    });
    return AssignTermLayoutView;
});