define([ "require", "backbone", "hbs!tmpl/audit/CreateAuditTableLayoutView_tmpl", "utils/Enums", "utils/CommonViewFunction", "utils/Utils" ], function(require, Backbone, CreateAuditTableLayoutViewTmpl, Enums, CommonViewFunction, Utils) {
    "use strict";
    var CreateAuditTableLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "CreateAuditTableLayoutView",
        template: CreateAuditTableLayoutViewTmpl,
        regions: {},
        ui: {
            auditValue: "[data-id='auditValue']",
            auditCreate: "[data-id='auditCreate']",
            noData: "[data-id='noData']",
            tableAudit: "[data-id='tableAudit']",
            auditHeaderValue: "[data-id='auditHeaderValue']",
            name: "[data-id='name']"
        },
        events: function() {
            var events = {};
            return events["click " + this.ui.auditCreate] = "onClickAuditCreate", events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "guid", "entityModel", "action", "entity", "entityName", "attributeDefs"));
        },
        bindEvents: function() {},
        onRender: function() {
            this.auditTableGenerate();
        },
        auditTableGenerate: function() {
            var table = "", detailObj = this.entityModel.get("details");
            if (detailObj && detailObj.search(":") >= 0) {
                var parseDetailsObject = detailObj.split(":");
                if (parseDetailsObject.length > 1) {
                    parseDetailsObject.shift();
                    var auditData = parseDetailsObject.join(":");
                }
                try {
                    parseDetailsObject = JSON.parse(auditData);
                    var skipAttribute = parseDetailsObject.typeName ? "guid" : null, name = Utils.getName(parseDetailsObject, null, skipAttribute);
                    "-" == name && (name = _.escape(parseDetailsObject.typeName));
                } catch (err) {
                    if (_.isArray(parseDetailsObject)) var name = _.escape(parseDetailsObject[0]);
                }
                var name = name ? name : this.entityName;
                this.ui.name.text(name), parseDetailsObject ? (this.ui.auditHeaderValue.html("<th>Key</th><th>New Value</th>"), 
                table = CommonViewFunction.propertyTable({
                    scope: this,
                    valueObject: parseDetailsObject,
                    attributeDefs: this.attributeDefs
                }), table.length ? (this.ui.noData.hide(), this.ui.tableAudit.show(), this.ui.auditValue.html(table)) : (this.ui.noData.show(), 
                this.ui.tableAudit.hide())) : this.ui.noData.show();
            } else "Deleted entity" == detailObj && this.ui.name.text(this.entityName);
        }
    });
    return CreateAuditTableLayoutView;
});