define([ "require", "backbone", "hbs!tmpl/common/TableLayout_tmpl", "backgrid-filter", "backgrid-paginator", "backgrid-sizeable", "backgrid-orderable", "backgrid-select-all", "backgrid-columnmanager" ], function(require, Backbone, FSTablelayoutTmpl) {
    "use strict";
    var FSTableLayout = Backbone.Marionette.LayoutView.extend({
        _viewName: "FSTableLayout",
        template: FSTablelayoutTmpl,
        templateHelpers: function() {
            return this.options;
        },
        regions: {
            rTableList: 'div[data-id="r_tableList"]',
            rTableSpinner: 'div[data-id="r_tableSpinner"]',
            rPagination: 'div[data-id="r_pagination"]',
            rFooterRecords: 'div[data-id="r_footerRecords"]'
        },
        ui: {
            selectPageSize: 'select[data-id="pageSize"]'
        },
        gridOpts: {
            className: "table table-bordered table-hover table-condensed backgrid",
            emptyText: "No Records found!"
        },
        filterOpts: {
            placeholder: "plcHldr.searchByResourcePath",
            wait: 150
        },
        paginatorOpts: {
            windowSize: 5,
            slideScale: .5,
            goBackFirstOnSort: !1
        },
        controlOpts: {
            rewind: null,
            back: {
                label: "<i class='fa fa-angle-left'></i>",
                title: "Previous"
            },
            forward: {
                label: "<i class='fa fa-angle-right'></i>",
                title: "Next"
            },
            fastForward: null
        },
        columnOpts: {
            opts: {
                initialColumnsVisible: 4,
                saveState: !1,
                loadStateOnInit: !0
            },
            visibilityControlOpts: {},
            el: null
        },
        includePagination: !0,
        includeFilter: !1,
        includeHeaderSearch: !1,
        includePageSize: !1,
        includeFooterRecords: !0,
        includeColumnManager: !1,
        includeSizeAbleColumns: !1,
        includeOrderAbleColumns: !1,
        includeTableLoader: !0,
        events: function() {
            var events = {};
            return events["change " + this.ui.selectPageSize] = "onPageSizeChange", events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "collection", "columns", "includePagination", "includeHeaderSearch", "includeFilter", "includePageSize", "includeFooterRecords", "includeColumnManager", "includeSizeAbleColumns", "includeOrderAbleColumns", "includeTableLoader")), 
            _.extend(this.gridOpts, options.gridOpts, {
                collection: this.collection,
                columns: this.columns
            }), _.extend(this.filterOpts, options.filterOpts), _.extend(this.paginatorOpts, options.paginatorOpts), 
            _.extend(this.controlOpts, options.controlOpts), _.extend(this.columnOpts, options.columnOpts), 
            this.bindEvents();
        },
        bindEvents: function() {
            this.listenTo(this.collection, "request", function() {
                this.$('div[data-id="r_tableSpinner"]').addClass("show");
            }, this), this.listenTo(this.collection, "sync error", function() {
                this.$('div[data-id="r_tableSpinner"]').removeClass("show");
            }, this), this.listenTo(this.collection, "reset", function(collection, response) {
                this.includePagination && this.renderPagination(), this.includeFooterRecords && this.renderFooterRecords(this.collection.state);
            }, this), this.listenTo(this.collection, "backgrid:sort", function() {
                this.collection.trigger("sort");
            }), this.listenTo(this.collection, "backgrid:refresh", function() {}, this);
        },
        onRender: function() {
            this.renderTable(), this.includePagination && this.renderPagination(), this.includeFilter && this.renderFilter(), 
            this.includeFooterRecords && this.renderFooterRecords(this.collection.state), this.includeColumnManager && this.renderColumnManager(), 
            this.includeSizeAbleColumns && this.renderSizeAbleColumns(), this.includeOrderAbleColumns && this.renderOrderAbleColumns(), 
            this.includePageSize && (this.ui.selectPageSize.select2({
                data: _.sortBy(_.union([ 25, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500 ], [ this.collection.state.pageSize ])),
                tags: !0,
                dropdownCssClass: "number-input",
                multiple: !1
            }), this.ui.selectPageSize.val(this.collection.state.pageSize).trigger("change", {
                skipViewChange: !0
            }));
        },
        renderTable: function() {
            var that = this;
            this.rTableList.show(new Backgrid.Grid(this.gridOpts).on("backgrid:rendered", function() {
                that.trigger("backgrid:rendered", this);
            }));
        },
        renderPagination: function() {
            var options = _.extend({
                collection: this.collection,
                controls: this.controlOpts
            }, this.paginatorOpts);
            this.rPagination ? this.rPagination.show(new Backgrid.Extension.Paginator(options)) : this.regions.rPagination && this.$('div[data-id="r_pagination"]').show(new Backgrid.Extension.Paginator(options));
        },
        showHidePager: function() {
            this.includePagination && (this.collection.state && this.collection.state.totalRecords > this.collection.state.pageSize ? this.$('div[data-id="r_pagination"]').show() : this.$('div[data-id="r_pagination"]').hide());
        },
        renderFilter: function() {
            this.rFilter.show(new Backgrid.Extension.ServerSideFilter({
                collection: this.collection,
                name: [ "name" ],
                placeholder: "plcHldr.searchByResourcePath",
                wait: 150
            })), setTimeout(function() {
                that.$("table").colResizable({
                    liveDrag: !0
                });
            }, 0);
        },
        renderFooterRecords: function(collectionState) {
            var collState = collectionState, totalRecords = collState.totalRecords || 0, pageStartIndex = totalRecords ? collState.currentPage * collState.pageSize : 0, pageEndIndex = pageStartIndex + this.collection.length;
            return this.$('[data-id="r_footerRecords"]').html("<h5>Showing " + (totalRecords ? pageStartIndex + 1 : 0 === this.collection.length ? 0 : 1) + " - " + pageEndIndex + "</h5>"), 
            this;
        },
        renderColumnManager: function() {
            var that = this, $el = this.columnOpts.el || this.$("[data-id='control']"), colManager = new Backgrid.Extension.ColumnManager(this.columns, this.columnOpts.opts), colVisibilityControl = new Backgrid.Extension.ColumnManagerVisibilityControl(_.extend({
                columnManager: colManager
            }, this.columnOpts.visibilityControlOpts));
            $el.jquery || ($el = $($el)), this.columnOpts.el ? $el.html(colVisibilityControl.render().el) : $el.append(colVisibilityControl.render().el), 
            colManager.on("state-changed", function(state) {
                that.collection.trigger("state-changed", state);
            }), colManager.on("state-saved", function() {
                that.collection.trigger("state-changed");
            });
        },
        renderSizeAbleColumns: function() {
            var sizeAbleCol = new Backgrid.Extension.SizeAbleColumns({
                collection: this.collection,
                columns: this.columns,
                grid: this.getGridObj()
            });
            this.$("thead").before(sizeAbleCol.render().el);
            var sizeHandler = new Backgrid.Extension.SizeAbleColumnsHandlers({
                sizeAbleColumns: sizeAbleCol,
                saveModelWidth: !0
            });
            this.$("thead").before(sizeHandler.render().el), this.columns.on("resize", function(columnModel, newWidth, oldWidth) {
                console.log("Resize event on column; name, model, new and old width: ", columnModel.get("name"), columnModel, newWidth, oldWidth);
            });
        },
        renderOrderAbleColumns: function() {
            var sizeAbleCol = new Backgrid.Extension.SizeAbleColumns({
                collection: this.collection,
                grid: this.getGridObj(),
                columns: this.columns
            });
            this.$("thead").before(sizeAbleCol.render().el);
            var orderHandler = new Backgrid.Extension.OrderableColumns({
                grid: this.getGridObj(),
                sizeAbleColumns: sizeAbleCol
            });
            this.$("thead").before(orderHandler.render().el);
        },
        onClose: function() {},
        getGridObj: function() {
            return this.rTableList.currentView ? this.rTableList.currentView : null;
        },
        onPageSizeChange: function(e, options) {
            if (!options || !options.skipViewChange) {
                var pagesize = $(e.currentTarget).val();
                this.collection.state.pageSize = parseInt(pagesize, 10), this.collection.state.currentPage = this.collection.state.firstPage, 
                "client" == this.collection.mode ? this.collection.reset(this.collection.toJSON()) : this.collection.fetch({
                    sort: !1,
                    reset: !0,
                    cache: !1
                });
            }
        }
    });
    return FSTableLayout;
});