define([ "require", "utils/Utils", "marionette", "backgrid", "asBreadcrumbs", "jquery-placeholder" ], function(require, Utils) {
    "use strict";
    Backbone.$.ajaxSetup({
        cache: !1
    });
    var oldBackboneSync = Backbone.sync;
    Backbone.sync = function(method, model, options) {
        var that = this;
        return oldBackboneSync.apply(this, [ method, model, _.extend(options, {
            error: function(response) {
                options.skipDefaultError || Utils.defaultErrorHandler(that, response), that.trigger("error", that, response), 
                options.cust_error && options.cust_error(that, response);
            }
        }) ]);
    }, _.mixin({
        isEmptyArray: function(val) {
            return !(!val || !_.isArray(val)) && _.isEmpty(val);
        },
        startsWith: function(str, matchStr) {
            return str && matchStr && _.isString(str) && _.isString(matchStr) ? 0 === str.lastIndexOf(matchStr, 0) : void 0;
        },
        isUndefinedNull: function(val) {
            return !(!_.isUndefined(val) && !_.isNull(val));
        },
        trim: function(val) {
            return val && val.trim ? val.trim() : val;
        },
        isTypePrimitive: function(type) {
            return "int" === type || "byte" === type || "short" === type || "long" === type || "float" === type || "double" === type || "string" === type || "boolean" === type || "date" === type;
        }
    });
    var getPopoverEl = function(e) {
        return $(e.target).parent().data("bs.popover") || $(e.target).data("bs.popover") || $(e.target).parents(".popover").length;
    };
    if ($(document).on("click DOMMouseScroll mousewheel", function(e) {
        if (e.originalEvent) {
            var isPopOverEl = getPopoverEl(e);
            isPopOverEl ? isPopOverEl.$tip && $(".popover").not(isPopOverEl.$tip).popover("hide") : $(".popover").popover("hide");
        }
    }), $("body").on("hidden.bs.popover", function(e) {
        $(e.target).data("bs.popover").inState = {
            click: !1,
            hover: !1,
            focus: !1
        };
    }), $("body").on("show.bs.popover", '[data-js="popover"]', function() {
        $(".popover").not(this).popover("hide");
    }), $("body").on("keypress", "input.number-input,.number-input .select2-search__field", function(e) {
        if (8 != e.which && 0 != e.which && (e.which < 48 || e.which > 57)) return !1;
    }), $("body").on("keypress", "input.number-input-negative,.number-input-negative .select2-search__field", function(e) {
        if (8 != e.which && 0 != e.which && (e.which < 48 || e.which > 57)) {
            if (45 != e.which) return !1;
            if (this.value.length) return !1;
        }
    }), $("body").on("keypress", "input.number-input-exponential,.number-input-exponential .select2-search__field", function(e) {
        if (8 != e.which && 0 != e.which && (e.which < 48 || e.which > 57) && 69 != e.which && 101 != e.which && 43 != e.which && 45 != e.which && 46 != e.which && 190 != e.which) return !1;
    }), $("body").on("click", ".dropdown-menu.dropdown-changetitle li a", function() {
        $(this).parents("li").find(".btn:first-child").html($(this).text() + ' <span class="caret"></span>');
    }), $("body").on("click", ".btn", function() {
        $(this).blur();
    }), !("placeholder" in HTMLInputElement.prototype)) {
        var originalRender = Backbone.Marionette.LayoutView.prototype.render;
        Backbone.Marionette.LayoutView.prototype.render = function() {
            originalRender.apply(this, arguments), this.$("input, textarea").placeholder();
        };
    }
    String.prototype.trunc = String.prototype.trunc || function(n) {
        return this.length > n ? this.substr(0, n - 1) + "..." : this;
    }, String.prototype.capitalize = function() {
        return this.charAt(0).toUpperCase() + this.slice(1);
    };
    var cellInit = Backgrid.Cell.prototype.initialize;
    Backgrid.Cell.prototype.initialize = function() {
        cellInit.apply(this, arguments);
        var className = this.column.get("className"), rowClassName = this.column.get("rowClassName");
        rowClassName && this.$el.addClass(rowClassName), className && this.$el.addClass(className);
    }, Backgrid.HeaderRow = Backgrid.HeaderRow.extend({
        render: function() {
            var that = this;
            return Backgrid.HeaderRow.__super__.render.apply(this, arguments), _.each(this.columns.models, function(modelValue) {
                var elAttr = modelValue.get("elAttr"), elAttrObj = null;
                elAttr && (_.isFunction(elAttr) ? elAttrObj = elAttr(modelValue) : _.isObject(elAttr) && (elAttrObj = _.isArray(elAttr) ? elAttr : [ elAttr ]), 
                _.each(elAttrObj, function(val) {
                    that.$el.find("." + modelValue.get("name")).data(val);
                })), modelValue.get("width") && that.$el.find("." + modelValue.get("name")).css("min-width", modelValue.get("width") + "px"), 
                modelValue.get("toolTip") && that.$el.find("." + modelValue.get("name")).attr("title", modelValue.get("toolTip"));
            }), this;
        }
    });
    var BackgridHeaderInitializeMethod = (Backgrid.HtmlCell = Backgrid.Cell.extend({
        className: "html-cell",
        render: function() {
            this.$el.empty();
            var rawValue = this.model.get(this.column.get("name")), formattedValue = this.formatter.fromRaw(rawValue, this.model);
            return this.$el.append(formattedValue), this.delegateEvents(), this;
        }
    }), function(options) {
        this.columns = options.columns, this.columns instanceof Backbone.Collection || (this.columns = new Backgrid.Columns(this.columns)), 
        this.createHeaderRow(), this.listenTo(this.columns, "sort", _.bind(function() {
            this.createHeaderRow(), this.render();
        }, this));
    }), BackgridHeaderCreateHeaderRowMethod = function() {
        this.row = new Backgrid.HeaderRow({
            columns: this.columns,
            collection: this.collection
        });
    }, BackgridHeaderRenderMethod = function() {
        return this.$el.empty(), this.$el.append(this.row.render().$el), this.delegateEvents(), 
        this.trigger("backgrid:header:rendered", this), this;
    };
    Backgrid.Header.prototype.initialize = BackgridHeaderInitializeMethod, Backgrid.Header.prototype.createHeaderRow = BackgridHeaderCreateHeaderRowMethod, 
    Backgrid.Header.prototype.render = BackgridHeaderRenderMethod;
    var UriCell = Backgrid.UriCell = Backgrid.Cell.extend({
        className: "uri-cell",
        title: null,
        target: "_blank",
        initialize: function(options) {
            UriCell.__super__.initialize.apply(this, arguments), this.title = options.title || this.title, 
            this.target = options.target || this.target;
        },
        render: function() {
            this.$el.empty();
            var rawValue = this.model.get(this.column.get("name")), href = _.isFunction(this.column.get("href")) ? this.column.get("href")(this.model) : this.column.get("href"), klass = this.column.get("klass"), formattedValue = this.formatter.fromRaw(rawValue, this.model);
            if (this.$el.append($("<a>", {
                tabIndex: -1,
                href: href,
                title: this.title || formattedValue,
                class: klass
            }).text(formattedValue)), this.column.has("iconKlass")) {
                var iconKlass = this.column.get("iconKlass"), iconTitle = this.column.get("iconTitle");
                this.$el.find("a").append('<i class="' + iconKlass + '" title="' + iconTitle + '"></i>');
            }
            return this.delegateEvents(), this;
        }
    });
});