define([ "require" ], function(require) {
    "use strict";
    var Enums = {};
    Enums.auditAction = {
        ENTITY_CREATE: "Entity Created",
        ENTITY_UPDATE: "Entity Updated",
        ENTITY_DELETE: "Entity Deleted",
        CLASSIFICATION_ADD: "Classification Added",
        CLASSIFICATION_DELETE: "Classification Deleted",
        CLASSIFICATION_UPDATE: "Classification Updated",
        PROPAGATED_CLASSIFICATION_ADD: "Propagated Classification Added",
        PROPAGATED_CLASSIFICATION_DELETE: "Propagated Classification Deleted",
        PROPAGATED_CLASSIFICATION_UPDATE: "Propagated Classification Updated",
        ENTITY_IMPORT_CREATE: "Entity Created by import",
        ENTITY_IMPORT_UPDATE: "Entity Updated by import",
        ENTITY_IMPORT_DELETE: "Entity Deleted by import",
        TERM_ADD: "Term Added",
        TERM_DELETE: "Term Deleted"
    }, Enums.entityStateReadOnly = {
        ACTIVE: !1,
        DELETED: !0,
        STATUS_ACTIVE: !1,
        STATUS_DELETED: !0
    }, Enums.lineageUrlType = {
        INPUT: "inputs",
        OUTPUT: "outputs",
        SCHEMA: "schema"
    }, Enums.searchUrlType = {
        DSL: "dsl",
        FULLTEXT: "basic"
    }, Enums.profileTabType = {
        "count-frequency": "Count Frequency Distribution",
        "decile-frequency": "Decile Frequency Distribution",
        annual: "Annual Distribution"
    }, Enums.extractFromUrlForSearch = {
        searchParameters: {
            pageLimit: "limit",
            type: "typeName",
            tag: "classification",
            query: "query",
            pageOffset: "offset",
            includeDE: "excludeDeletedEntities",
            excludeST: "includeSubTypes",
            excludeSC: "includeSubClassifications",
            tagFilters: "tagFilters",
            entityFilters: "entityFilters",
            attributes: "attributes",
            term: "termName"
        },
        uiParameters: "uiParameters"
    }, Enums.regex = {
        RANGE_CHECK: {
            byte: {
                min: -128,
                max: 127
            },
            short: {
                min: -32768,
                max: 32767
            },
            int: {
                min: -2147483648,
                max: 2147483647
            },
            long: {
                min: -0x8000000000000000,
                max: 0x8000000000000000
            },
            float: {
                min: -3.4028235e38,
                max: 3.4028235e38
            },
            double: {
                min: -1.7976931348623157e308,
                max: 1.7976931348623157e308
            }
        }
    }, Enums.graphIcon = {};
    var getTermRelationAttributes = function() {
        return {
            description: null,
            expression: null,
            steward: null,
            source: null
        };
    };
    return Enums.termRelationAttributeList = {
        seeAlso: getTermRelationAttributes(),
        synonyms: getTermRelationAttributes(),
        antonyms: getTermRelationAttributes(),
        preferredTerms: getTermRelationAttributes(),
        preferredToTerms: getTermRelationAttributes(),
        replacementTerms: getTermRelationAttributes(),
        replacedBy: getTermRelationAttributes(),
        translationTerms: getTermRelationAttributes(),
        translatedTerms: getTermRelationAttributes(),
        isA: getTermRelationAttributes(),
        classifies: getTermRelationAttributes(),
        validValues: getTermRelationAttributes(),
        validValuesFor: getTermRelationAttributes()
    }, Enums.addOnClassification = [ "_CLASSIFIED", "_NOT_CLASSIFIED" ], Enums;
});