define([ "jquery", "underscore", "backbone", "App", "utils/Globals", "utils/Utils", "utils/UrlLinks", "collection/VGlossaryList" ], function($, _, Backbone, App, Globals, Utils, UrlLinks, VGlossaryList) {
    var AppRouter = Backbone.Router.extend({
        routes: {
            "": "defaultAction",
            "!/": "tagAttributePageLoad",
            "!/tag/tagAttribute/(*name)": "tagAttributePageLoad",
            "!/search/searchResult": "searchResult",
            "!/detailPage/:id": "detailPage",
            "!/tag": "commonAction",
            "!/search": "commonAction",
            "!/glossary": "commonAction",
            "!/glossary/:id": "glossaryDetailPage",
            "*actions": "defaultAction"
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "entityDefCollection", "typeHeaders", "enumDefCollection", "classificationDefCollection")), 
            this.showRegions(), this.bindCommonEvents(), this.listenTo(this, "route", this.postRouteExecute, this), 
            this.searchVent = new Backbone.Wreqr.EventAggregator(), this.glossaryCollection = new VGlossaryList([], {
                comparator: function(item) {
                    return item.get("name");
                }
            }), this.preFetchedCollectionLists = {
                entityDefCollection: this.entityDefCollection,
                typeHeaders: this.typeHeaders,
                enumDefCollection: this.enumDefCollection,
                classificationDefCollection: this.classificationDefCollection,
                glossaryCollection: this.glossaryCollection
            }, this.sharedObj = {
                searchTableColumns: {},
                glossary: {
                    selectedItem: {}
                },
                searchTableFilters: {
                    tagFilters: {},
                    entityFilters: {}
                }
            };
        },
        bindCommonEvents: function() {
            $("body").on("click", "li.aboutAtlas", function() {
                require([ "views/common/AboutAtlas" ], function(AboutAtlas) {
                    new AboutAtlas();
                });
            });
        },
        showRegions: function() {},
        execute: function(callback, args) {
            this.preRouteExecute(), callback && callback.apply(this, args), this.postRouteExecute();
        },
        preRouteExecute: function() {},
        postRouteExecute: function(name, args) {},
        detailPage: function(id) {
            var that = this;
            id && require([ "views/site/Header", "views/detail_page/DetailPageLayoutView", "views/site/SideNavLayoutView", "collection/VEntityList" ], function(Header, DetailPageLayoutView, SideNavLayoutView, VEntityList) {
                this.entityCollection = new VEntityList([], {});
                var paramObj = Utils.getUrlState.getQueryParams();
                App.rNHeader.show(new Header()), App.rSideNav.currentView ? App.rSideNav.currentView.selectTab() : App.rSideNav.show(new SideNavLayoutView(_.extend({}, that.preFetchedCollectionLists, that.sharedObj))), 
                App.rNContent.show(new DetailPageLayoutView(_.extend({
                    collection: this.entityCollection,
                    id: id,
                    value: paramObj
                }, that.preFetchedCollectionLists, that.sharedObj))), this.entityCollection.url = UrlLinks.entitiesApiUrl({
                    guid: id,
                    minExtInfo: !0
                }), this.entityCollection.fetch({
                    reset: !0
                });
            });
        },
        tagAttributePageLoad: function(tagName) {
            var that = this;
            require([ "views/site/Header", "views/site/SideNavLayoutView", "views/tag/TagDetailLayoutView" ], function(Header, SideNavLayoutView, TagDetailLayoutView) {
                var paramObj = Utils.getUrlState.getQueryParams(), url = Utils.getUrlState.getQueryUrl().queyParams[0];
                if (App.rNHeader.show(new Header()), App.rSideNav.currentView ? (paramObj && paramObj.dlttag && Utils.setUrl({
                    url: url,
                    trigger: !1,
                    updateTabState: !0
                }), App.rSideNav.currentView.RTagLayoutView.currentView.manualRender(_.extend({}, paramObj, {
                    tagName: tagName
                })), App.rSideNav.currentView.selectTab()) : (paramObj && paramObj.dlttag && Utils.setUrl({
                    url: url,
                    trigger: !1,
                    updateTabState: !0
                }), App.rSideNav.show(new SideNavLayoutView(_.extend({
                    tag: tagName,
                    value: paramObj
                }, that.preFetchedCollectionLists, that.sharedObj)))), tagName) {
                    if (paramObj = Utils.getUrlState.getQueryParams(), paramObj && paramObj.dlttag) return !1;
                    App.rNContent.show(new TagDetailLayoutView(_.extend({
                        tag: tagName,
                        value: paramObj
                    }, that.preFetchedCollectionLists, that.sharedObj)));
                }
            });
        },
        glossaryDetailPage: function(id) {
            var that = this;
            id && require([ "views/site/Header", "views/glossary/GlossaryDetailLayoutView", "views/site/SideNavLayoutView" ], function(Header, GlossaryDetailLayoutView, SideNavLayoutView) {
                var paramObj = Utils.getUrlState.getQueryParams();
                App.rNHeader.show(new Header()), App.rSideNav.currentView ? (App.rSideNav.currentView.RGlossaryLayoutView.currentView.manualRender(_.extend({}, {
                    guid: id,
                    value: paramObj
                })), App.rSideNav.currentView.selectTab()) : App.rSideNav.show(new SideNavLayoutView(_.extend({}, that.preFetchedCollectionLists, that.sharedObj, {
                    guid: id,
                    value: paramObj
                }))), App.rNContent.show(new GlossaryDetailLayoutView(_.extend({
                    guid: id,
                    value: paramObj
                }, that.preFetchedCollectionLists, that.sharedObj)));
            });
        },
        commonAction: function() {
            var that = this;
            require([ "views/site/Header", "views/site/SideNavLayoutView", "views/search/SearchDetailLayoutView" ], function(Header, SideNavLayoutView, SearchDetailLayoutView) {
                var paramObj = Utils.getUrlState.getQueryParams();
                App.rNHeader.show(new Header()), App.rSideNav.currentView ? (App.rSideNav.currentView.selectTab(), 
                Utils.getUrlState.isTagTab() ? App.rSideNav.currentView.RTagLayoutView.currentView.manualRender() : Utils.getUrlState.isGlossaryTab() && App.rSideNav.currentView.RGlossaryLayoutView.currentView.manualRender(_.extend({
                    isTrigger: !0
                }, {
                    value: paramObj
                }))) : App.rSideNav.show(new SideNavLayoutView(_.extend({
                    searchVent: that.searchVent
                }, that.preFetchedCollectionLists, that.sharedObj))), Globals.entityCreate && Utils.getUrlState.isSearchTab() ? App.rNContent.show(new SearchDetailLayoutView(_.extend({
                    value: paramObj,
                    initialView: !0,
                    searchVent: that.searchVent
                }, that.preFetchedCollectionLists, that.sharedObj))) : (App.rNContent.$el.html(""), 
                App.rNContent.destroy());
            });
        },
        searchResult: function() {
            var that = this;
            require([ "views/site/Header", "views/site/SideNavLayoutView", "views/search/SearchDetailLayoutView" ], function(Header, SideNavLayoutView, SearchDetailLayoutView) {
                var paramObj = Utils.getUrlState.getQueryParams(), isinitialView = !0, tempParam = _.extend({}, paramObj);
                App.rNHeader.show(new Header()), App.rSideNav.currentView ? App.rSideNav.currentView.RSearchLayoutView.currentView.manualRender(paramObj) : App.rSideNav.show(new SideNavLayoutView(_.extend({
                    value: paramObj,
                    searchVent: that.searchVent
                }, that.preFetchedCollectionLists, that.sharedObj))), App.rSideNav.currentView.selectTab(), 
                paramObj && (isinitialView = 0 === (paramObj.type || ("true" == paramObj.dslChecked ? "" : paramObj.tag || paramObj.term) || (paramObj.query ? paramObj.query.trim() : "")).length), 
                App.rNContent.show(new SearchDetailLayoutView(_.extend({
                    value: paramObj,
                    searchVent: that.searchVent,
                    initialView: isinitialView,
                    isTypeTagNotExists: paramObj.type != tempParam.type || tempParam.tag != paramObj.tag
                }, that.preFetchedCollectionLists, that.sharedObj)));
            });
        },
        defaultAction: function(actions) {
            Utils.setUrl({
                url: "#!/search",
                mergeBrowserUrl: !1,
                trigger: !0,
                updateTabState: !0
            }), console.log("No route:", actions);
        }
    });
    return AppRouter;
});