/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.model.instance.AtlasEntityHeader;

public interface AtlasAuthorizer {
    public void init();

    public void cleanUp();

    public boolean isAccessAllowed(AtlasAdminAccessRequest var1) throws AtlasAuthorizationException;

    public boolean isAccessAllowed(AtlasEntityAccessRequest var1) throws AtlasAuthorizationException;

    public boolean isAccessAllowed(AtlasTypeAccessRequest var1) throws AtlasAuthorizationException;

    default public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) throws AtlasAuthorizationException {
        return true;
    }

    default public void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
    }

    default public void scrubEntityHeader(AtlasEntityHeader entity) {
        entity.setGuid("-1");
        if (entity.getAttributes() != null) {
            entity.getAttributes().clear();
        }
        if (entity.getClassifications() != null) {
            entity.getClassifications().clear();
        }
        if (entity.getClassificationNames() != null) {
            entity.getClassificationNames().clear();
        }
        if (entity.getMeanings() != null) {
            entity.getMeanings().clear();
        }
        if (entity.getMeaningNames() != null) {
            entity.getMeaningNames().clear();
        }
    }
}

