/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.DebugCommand;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.io.Text;

public class TraceCommand
extends DebugCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException {
        if (cl.getArgs().length == 1) {
            if (cl.getArgs()[0].equalsIgnoreCase("on")) {
                Trace.on((String)("shell:" + shellState.getPrincipal()));
                return 0;
            }
            if (!cl.getArgs()[0].equalsIgnoreCase("off")) throw new BadArgumentException("Argument must be 'on' or 'off'", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
            if (Trace.isTracing()) {
                long trace = Trace.currentTraceId();
                Trace.off();
                StringBuilder sb = new StringBuilder();
                int traceCount = 0;
                for (int i = 0; i < 30; ++i) {
                    sb = new StringBuilder();
                    try {
                        Map properties = shellState.getConnector().instanceOperations().getSystemConfiguration();
                        String table = (String)properties.get(Property.TRACE_TABLE.getKey());
                        String user = shellState.getConnector().whoami();
                        Authorizations auths = shellState.getConnector().securityOperations().getUserAuthorizations(user);
                        Scanner scanner = shellState.getConnector().createScanner(table, auths);
                        scanner.setRange(new Range(new Text(Long.toHexString(trace))));
                        final StringBuilder finalSB = sb;
                        traceCount = TraceDump.printTrace((Scanner)scanner, (TraceDump.Printer)new TraceDump.Printer(){

                            public void print(String line) {
                                try {
                                    finalSB.append(line + "\n");
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        });
                        if (traceCount > 0) {
                            shellState.getReader().print((CharSequence)sb.toString());
                            break;
                        }
                    }
                    catch (Exception ex) {
                        shellState.printException(ex);
                    }
                    shellState.getReader().println((CharSequence)"Waiting for trace information");
                    shellState.getReader().flush();
                    UtilWaitThread.sleep((long)500L);
                }
                if (traceCount >= 0) return 0;
                shellState.getReader().print((CharSequence)sb.toString());
                return 0;
            }
            shellState.getReader().println((CharSequence)"Not tracing");
            return 0;
        }
        if (cl.getArgs().length == 0) {
            shellState.getReader().println((CharSequence)(Trace.isTracing() ? "on" : "off"));
            return 0;
        } else {
            shellState.printException(new IllegalArgumentException("Expected 0 or 1 argument. There were " + cl.getArgs().length + "."));
            this.printHelp(shellState);
            return 1;
        }
    }

    @Override
    public String description() {
        return "turns trace logging on or off";
    }
}

