/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.GrepIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.interpret.ScanInterpreter;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GrepCommand
extends ScanCommand {
    private Option numThreadsOpt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        Shell.PrintFile printFile = this.getOutputFile(cl);
        String tableName = OptUtil.getTableOpt(cl, shellState);
        if (cl.getArgList().isEmpty()) {
            throw new MissingArgumentException("No terms specified");
        }
        Class<? extends Formatter> formatter = this.getFormatter(cl, tableName, shellState);
        ScanInterpreter interpeter = this.getInterpreter(cl, tableName, shellState);
        int numThreads = 20;
        if (cl.hasOption(this.numThreadsOpt.getOpt())) {
            numThreads = Integer.parseInt(cl.getOptionValue(this.numThreadsOpt.getOpt()));
        }
        Authorizations auths = this.getAuths(cl, shellState);
        BatchScanner scanner = shellState.getConnector().createBatchScanner(tableName, auths, numThreads);
        scanner.setRanges(Collections.singletonList(this.getRange(cl, interpeter)));
        scanner.setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS);
        for (int i = 0; i < cl.getArgs().length; ++i) {
            this.setUpIterator(Integer.MAX_VALUE - cl.getArgs().length + i, "grep" + i, cl.getArgs()[i], scanner, cl);
        }
        try {
            this.fetchColumns(cl, (ScannerBase)scanner, interpeter);
            this.printRecords(cl, shellState, (Iterable<Map.Entry<Key, Value>>)scanner, formatter, printFile);
        }
        finally {
            scanner.close();
        }
        return 0;
    }

    protected void setUpIterator(int prio, String name, String term, BatchScanner scanner, CommandLine cl) throws IOException {
        if (prio < 0) {
            throw new IllegalArgumentException("Priority < 0 " + prio);
        }
        IteratorSetting grep = new IteratorSetting(prio, name, GrepIterator.class);
        GrepIterator.setTerm((IteratorSetting)grep, (String)term);
        scanner.addScanIterator(grep);
    }

    @Override
    public String description() {
        return "searches each row, column family, column qualifier and value in a table for a substring (not a regular expression), in parallel, on the server side";
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.numThreadsOpt = new Option("nt", "num-threads", true, "number of threads to use");
        opts.addOption(this.numThreadsOpt);
        return opts;
    }

    @Override
    public String usage() {
        return this.getName() + " <term>{ <term>}";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

