/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiskUsage {
    private static final Logger log = LoggerFactory.getLogger(TableDiskUsage.class);
    private int nextInternalId = 0;
    private Map<String, Integer> internalIds = new HashMap<String, Integer>();
    private Map<Integer, String> externalIds = new HashMap<Integer, String>();
    private Map<String, Integer[]> tableFiles = new HashMap<String, Integer[]>();
    private Map<String, Long> fileSizes = new HashMap<String, Long>();

    void addTable(String tableId) {
        if (this.internalIds.containsKey(tableId)) {
            throw new IllegalArgumentException("Already added table " + tableId);
        }
        int iid = this.nextInternalId++;
        this.internalIds.put(tableId, iid);
        this.externalIds.put(iid, tableId);
    }

    void linkFileAndTable(String tableId, String file) {
        int internalId = this.internalIds.get(tableId);
        Integer[] tables = this.tableFiles.get(file);
        if (tables == null) {
            tables = new Integer[this.internalIds.size()];
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = 0;
            }
            this.tableFiles.put(file, tables);
        }
        tables[internalId] = 1;
    }

    void addFileSize(String file, long size) {
        this.fileSizes.put(file, size);
    }

    Map<List<String>, Long> calculateUsage() {
        HashMap<List<Object>, Long> usage = new HashMap<List<Object>, Long>();
        if (log.isTraceEnabled()) {
            log.trace("fileSizes " + this.fileSizes);
        }
        for (Map.Entry<String, Integer[]> entry : this.tableFiles.entrySet()) {
            if (log.isTraceEnabled()) {
                log.trace("file " + entry.getKey() + " table bitset " + Arrays.toString((Object[])entry.getValue()));
            }
            List<Object> key = Arrays.asList((Object[])entry.getValue());
            Long size = this.fileSizes.get(entry.getKey());
            Long tablesUsage = (Long)usage.get(key);
            if (tablesUsage == null) {
                tablesUsage = 0L;
            }
            tablesUsage = tablesUsage + size;
            usage.put(key, tablesUsage);
        }
        HashMap<List<String>, Long> externalUsage = new HashMap<List<String>, Long>();
        for (Map.Entry entry : usage.entrySet()) {
            ArrayList<String> externalKey = new ArrayList<String>();
            List key = (List)entry.getKey();
            for (int i = 0; i < key.size(); ++i) {
                if ((Integer)key.get(i) == 0) continue;
                externalKey.add(this.externalIds.get(i));
            }
            externalUsage.put((List<String>)externalKey, (Long)entry.getValue());
        }
        return externalUsage;
    }

    public static void printDiskUsage(AccumuloConfiguration acuConf, Collection<String> tables, VolumeManager fs, Connector conn, boolean humanReadable) throws TableNotFoundException, IOException {
        TableDiskUsage.printDiskUsage(acuConf, tables, fs, conn, new Printer(){

            @Override
            public void print(String line) {
                System.out.println(line);
            }
        }, humanReadable);
    }

    public static Map<TreeSet<String>, Long> getDiskUsage(AccumuloConfiguration acuConf, Set<String> tableIds, VolumeManager fs, Connector conn) throws IOException {
        TableDiskUsage tdu = new TableDiskUsage();
        for (String tableId : tableIds) {
            tdu.addTable(tableId);
        }
        HashSet<String> tablesReferenced = new HashSet<String>(tableIds);
        HashSet<String> emptyTableIds = new HashSet<String>();
        HashSet<String> nameSpacesReferenced = new HashSet<String>();
        for (String string : tableIds) {
            Scanner scanner;
            Object var10_15 = null;
            try {
                scanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
            }
            catch (TableNotFoundException tableNotFoundException) {
                throw new RuntimeException(tableNotFoundException);
            }
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            scanner.setRange(new KeyExtent(new Text(string), null, null).toMetadataRange());
            if (!scanner.iterator().hasNext()) {
                emptyTableIds.add(string);
            }
            for (Map.Entry entry : scanner) {
                String file = ((Key)entry.getKey()).getColumnQualifier().toString();
                String[] parts = file.split("/");
                String uniqueName = parts[parts.length - 1];
                if (file.contains(":") || file.startsWith("../")) {
                    String ref = parts[parts.length - 3];
                    if (!ref.equals(string)) {
                        tablesReferenced.add(ref);
                    }
                    if (file.contains(":") && parts.length > 3) {
                        List<String> base = Arrays.asList(Arrays.copyOf(parts, parts.length - 3));
                        nameSpacesReferenced.add(Joiner.on((String)"/").join(base));
                    }
                }
                tdu.linkFileAndTable(string, uniqueName);
            }
        }
        for (String string : tablesReferenced) {
            for (String string2 : nameSpacesReferenced) {
                FileStatus[] fileStatusArray = fs.globStatus(new Path(string2 + "/" + string + "/*/*"));
                if (fileStatusArray == null) continue;
                for (FileStatus fileStatus : fileStatusArray) {
                    String name = fileStatus.getPath().getName();
                    tdu.addFileSize(name, fileStatus.getLen());
                }
            }
        }
        HashMap reverseTableIdMap = new HashMap();
        for (Map.Entry entry : conn.tableOperations().tableIdMap().entrySet()) {
            reverseTableIdMap.put(entry.getValue(), entry.getKey());
        }
        TreeMap<TreeSet<String>, Long> treeMap = new TreeMap<TreeSet<String>, Long>(new Comparator<TreeSet<String>>(){

            @Override
            public int compare(TreeSet<String> o1, TreeSet<String> o2) {
                int len1 = o1.size();
                int len2 = o2.size();
                int min = Math.min(len1, len2);
                Iterator<String> iter1 = o1.iterator();
                Iterator<String> iter2 = o2.iterator();
                for (int count = 0; count < min; ++count) {
                    String s2;
                    String s1 = iter1.next();
                    int cmp = s1.compareTo(s2 = iter2.next());
                    if (cmp == 0) continue;
                    return cmp;
                }
                return len1 - len2;
            }
        });
        for (Map.Entry<List<String>, Long> entry : tdu.calculateUsage().entrySet()) {
            TreeSet treeSet = new TreeSet();
            for (String tableId : entry.getKey()) {
                treeSet.add(reverseTableIdMap.get(tableId));
            }
            treeMap.put(treeSet, entry.getValue());
        }
        if (!emptyTableIds.isEmpty()) {
            TreeSet treeSet = new TreeSet();
            for (String string : emptyTableIds) {
                treeSet.add(reverseTableIdMap.get(string));
            }
            treeMap.put(treeSet, 0L);
        }
        return treeMap;
    }

    public static void printDiskUsage(AccumuloConfiguration acuConf, Collection<String> tables, VolumeManager fs, Connector conn, Printer printer, boolean humanReadable) throws TableNotFoundException, IOException {
        HashSet<String> tableIds = new HashSet<String>();
        for (String tableName : tables) {
            String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
            if (tableId == null) {
                throw new TableNotFoundException(null, tableName, "Table " + tableName + " not found");
            }
            tableIds.add(tableId);
        }
        Map<TreeSet<String>, Long> usage = TableDiskUsage.getDiskUsage(acuConf, tableIds, fs, conn);
        String valueFormat = humanReadable ? "%9s" : "%,24d";
        for (Map.Entry<TreeSet<String>, Long> entry : usage.entrySet()) {
            Serializable value = humanReadable ? NumUtil.bigNumberForSize((long)entry.getValue()) : (Serializable)entry.getValue();
            printer.print(String.format(valueFormat + " %s", value, entry.getKey()));
        }
    }

    public static void main(String[] args) throws Exception {
        VolumeManager fs = VolumeManagerImpl.get();
        Opts opts = new Opts();
        opts.parseArgs(TableDiskUsage.class.getName(), args, new Object[0]);
        Connector conn = opts.getConnector();
        TableDiskUsage.printDiskUsage((AccumuloConfiguration)DefaultConfiguration.getInstance(), opts.tables, fs, conn, false);
    }

    static class Opts
    extends ClientOpts {
        @Parameter(description=" <table> { <table> ... } ")
        List<String> tables = new ArrayList<String>();

        Opts() {
        }
    }

    public static interface Printer {
        public void print(String var1);
    }
}

