/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.util.Base64;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RestoreZookeeper {
    public static void main(String[] args) throws Exception {
        Logger.getRootLogger().setLevel(Level.WARN);
        Opts opts = new Opts();
        opts.parseArgs(RestoreZookeeper.class.getName(), args, new Object[0]);
        InputStream in = System.in;
        if (opts.file != null) {
            in = new FileInputStream(opts.file);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)new Restore((IZooReaderWriter)ZooReaderWriter.getInstance(), opts.overwrite));
        in.close();
    }

    static class Opts
    extends Help {
        @Parameter(names={"--overwrite"})
        boolean overwrite = false;
        @Parameter(names={"--file"})
        String file;

        Opts() {
        }
    }

    private static class Restore
    extends DefaultHandler {
        IZooReaderWriter zk = null;
        Stack<String> cwd = new Stack();
        boolean overwrite = false;

        Restore(IZooReaderWriter zk, boolean overwrite) {
            this.zk = zk;
            this.overwrite = overwrite;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("node".equals(name)) {
                String child = attributes.getValue("name");
                if (child == null) {
                    throw new RuntimeException("name attribute not set");
                }
                String encoding = attributes.getValue("encoding");
                String value = attributes.getValue("value");
                if (value == null) {
                    value = "";
                }
                String path = (String)this.cwd.lastElement() + "/" + child;
                this.create(path, value, encoding);
                this.cwd.push(path);
            } else if ("dump".equals(name)) {
                String root = attributes.getValue("root");
                if (root.equals("/")) {
                    this.cwd.push("");
                } else {
                    this.cwd.push(root);
                }
                this.create(root, "", StandardCharsets.UTF_8.name());
            } else if ("ephemeral".equals(name)) {
                this.cwd.push("");
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.cwd.pop();
        }

        private void create(String path, String value, String encoding) {
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            if ("base64".equals(encoding)) {
                data = Base64.decodeBase64((byte[])data);
            }
            try {
                try {
                    this.zk.putPersistentData(path, data, this.overwrite ? ZooUtil.NodeExistsPolicy.OVERWRITE : ZooUtil.NodeExistsPolicy.FAIL);
                }
                catch (KeeperException e) {
                    if (e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                        throw new RuntimeException(path + " exists.  Remove it first.");
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

