/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizeVolumes {
    private static final Logger log = LoggerFactory.getLogger(RandomizeVolumes.class);

    public static void main(String[] args) throws AccumuloException, AccumuloSecurityException {
        Connector c;
        ClientOnRequiredTable opts = new ClientOnRequiredTable();
        opts.parseArgs(RandomizeVolumes.class.getName(), args, new Object[0]);
        if (opts.getToken() == null) {
            AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(opts.getInstance()));
            c = context.getConnector();
        } else {
            c = opts.getConnector();
        }
        try {
            int status = RandomizeVolumes.randomize(c, opts.getTableName());
            System.exit(status);
        }
        catch (Exception ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            System.exit(4);
        }
    }

    public static int randomize(Connector c, String tableName) throws IOException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        final VolumeManager vm = VolumeManagerImpl.get();
        if (vm.getVolumes().size() < 2) {
            log.error("There are not enough volumes configured");
            return 1;
        }
        String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
        if (null == tableId) {
            log.error("Could not determine the table ID for table " + tableName);
            return 2;
        }
        TableState tableState = TableManager.getInstance().getTableState(tableId);
        if (TableState.OFFLINE != tableState) {
            log.info("Taking " + tableName + " offline");
            c.tableOperations().offline(tableName, true);
            log.info(tableName + " offline");
        }
        SimpleThreadPool pool = new SimpleThreadPool(50, "directory maker");
        log.info("Rewriting entries for " + tableName);
        Scanner scanner = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
        scanner.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        BatchWriter writer = c.createBatchWriter("accumulo.metadata", null);
        int count = 0;
        for (Map.Entry entry : scanner) {
            String directory;
            String oldLocation = ((Value)entry.getValue()).toString();
            if (oldLocation.contains(":")) {
                String[] parts = oldLocation.split("/");
                String tableIdEntry = parts[parts.length - 2];
                if (!tableIdEntry.equals(tableId)) {
                    log.error("Unexpected table id found: " + tableIdEntry + ", expected " + tableId + "; skipping");
                    continue;
                }
                directory = parts[parts.length - 1];
            } else {
                directory = oldLocation.substring("/".length());
            }
            Key key = (Key)entry.getKey();
            Mutation m = new Mutation(key.getRow());
            final String newLocation = vm.choose((Optional<String>)Optional.of((Object)tableId), ServerConstants.getBaseUris()) + "/" + "tables" + "/" + tableId + "/" + directory;
            m.put(key.getColumnFamily(), key.getColumnQualifier(), new Value(newLocation.getBytes(StandardCharsets.UTF_8)));
            if (log.isTraceEnabled()) {
                log.trace("Replacing " + oldLocation + " with " + newLocation);
            }
            writer.addMutation(m);
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        vm.mkdirs(new Path(newLocation));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            ++count;
        }
        writer.close();
        pool.shutdown();
        while (!pool.isTerminated()) {
            log.trace("Waiting for mkdir() calls to finish");
            try {
                pool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        log.info("Updated " + count + " entries for table " + tableName);
        if (TableState.OFFLINE != tableState) {
            c.tableOperations().online(tableName, true);
            log.info("table " + tableName + " back online");
        }
        return 0;
    }
}

