/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(MasterMetadataUtil.class);

    public static void addNewTablet(ClientContext context, KeyExtent extent, String path, TServerInstance location, Map<FileRef, DataFileValue> datafileSizes, Map<FileRef, Long> bulkLoadedFiles, String time, long lastFlushID, long lastCompactID, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(path.getBytes(StandardCharsets.UTF_8)));
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes(StandardCharsets.UTF_8)));
        if (lastFlushID > 0L) {
            MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value(("" + lastFlushID).getBytes()));
        }
        if (lastCompactID > 0L) {
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value(("" + lastCompactID).getBytes()));
        }
        if (location != null) {
            location.putLocation(m);
            location.clearFutureLocation(m);
        }
        for (Map.Entry<FileRef, DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, entry.getKey().meta(), new Value(entry.getValue().encode()));
        }
        for (Map.Entry<FileRef, Object> entry : bulkLoadedFiles.entrySet()) {
            byte[] tidBytes = Long.toString((Long)entry.getValue()).getBytes();
            m.put(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, entry.getKey().meta(), new Value(tidBytes));
        }
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static KeyExtent fixSplit(ClientContext context, Text metadataEntry, SortedMap<ColumnFQ, Value> columns, TServerInstance tserver, ZooLock lock) throws AccumuloException, IOException {
        log.info("Incomplete split " + metadataEntry + " attempting to fix");
        Value oper = (Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN);
        if (columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN) == null) {
            throw new IllegalArgumentException("Metadata entry does not have split ratio (" + metadataEntry + ")");
        }
        double splitRatio = Double.parseDouble(new String(((Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN)).get(), StandardCharsets.UTF_8));
        Value prevEndRowIBW = (Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
        if (prevEndRowIBW == null) {
            throw new IllegalArgumentException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        Value time = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
        if (time == null) {
            throw new IllegalArgumentException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        Value flushID = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN);
        long initFlushID = -1L;
        if (flushID != null) {
            initFlushID = Long.parseLong(flushID.toString());
        }
        Value compactID = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN);
        long initCompactID = -1L;
        if (compactID != null) {
            initCompactID = Long.parseLong(compactID.toString());
        }
        Text metadataPrevEndRow = KeyExtent.decodePrevEndRow((Value)prevEndRowIBW);
        Text table = new KeyExtent(metadataEntry, (Text)null).getTableId();
        return MasterMetadataUtil.fixSplit(context, table, metadataEntry, metadataPrevEndRow, oper, splitRatio, tserver, time.toString(), initFlushID, initCompactID, lock);
    }

    private static KeyExtent fixSplit(ClientContext context, Text table, Text metadataEntry, Text metadataPrevEndRow, Value oper, double splitRatio, TServerInstance tserver, String time, long initFlushID, long initCompactID, ZooLock lock) throws AccumuloException, IOException {
        if (metadataPrevEndRow == null) {
            throw new AccumuloException("Split tablet does not have prev end row, something is amiss, extent = " + metadataEntry);
        }
        Key prevRowKey = new Key(new Text(KeyExtent.getMetadataEntry((Text)table, (Text)metadataPrevEndRow)));
        ScannerImpl scanner2 = new ScannerImpl(context, "!0", Authorizations.EMPTY);
        scanner2.setRange(new Range(prevRowKey, prevRowKey.followingKey(PartialKey.ROW)));
        VolumeManager fs = VolumeManagerImpl.get();
        if (!scanner2.iterator().hasNext()) {
            log.info("Rolling back incomplete split " + metadataEntry + " " + metadataPrevEndRow);
            MetadataTableUtil.rollBackSplit(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper), context, lock);
            return new KeyExtent(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper));
        }
        log.info("Finishing incomplete split " + metadataEntry + " " + metadataPrevEndRow);
        ArrayList<FileRef> highDatafilesToRemove = new ArrayList<FileRef>();
        ScannerImpl scanner3 = new ScannerImpl(context, "!0", Authorizations.EMPTY);
        Key rowKey = new Key(metadataEntry);
        TreeMap<FileRef, DataFileValue> origDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        scanner3.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        scanner3.setRange(new Range(rowKey, rowKey.followingKey(PartialKey.ROW)));
        for (Map.Entry entry : scanner3) {
            if (((Key)entry.getKey()).compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) != 0) continue;
            origDatafileSizes.put(new FileRef(fs, (Key)entry.getKey()), new DataFileValue(((Value)entry.getValue()).get()));
        }
        MetadataTableUtil.splitDatafiles(table, metadataPrevEndRow, splitRatio, new HashMap<FileRef, FileUtil.FileInfo>(), origDatafileSizes, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
        MetadataTableUtil.finishSplit(metadataEntry, highDatafileSizes, highDatafilesToRemove, context, lock);
        return new KeyExtent(metadataEntry, KeyExtent.encodePrevEndRow((Text)metadataPrevEndRow));
    }

    private static TServerInstance getTServerInstance(String address, ZooLock zooLock) {
        while (true) {
            try {
                return new TServerInstance(address, zooLock.getSessionId());
            }
            catch (KeeperException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            catch (InterruptedException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            UtilWaitThread.sleep((long)1000L);
        }
    }

    public static void replaceDatafiles(ClientContext context, KeyExtent extent, Set<FileRef> datafilesToDelete, Set<FileRef> scanFiles, FileRef path, Long compactionId, DataFileValue size, String address, TServerInstance lastLocation, ZooLock zooLock) throws IOException {
        MasterMetadataUtil.replaceDatafiles(context, extent, datafilesToDelete, scanFiles, path, compactionId, size, address, lastLocation, zooLock, true);
    }

    public static void replaceDatafiles(ClientContext context, KeyExtent extent, Set<FileRef> datafilesToDelete, Set<FileRef> scanFiles, FileRef path, Long compactionId, DataFileValue size, String address, TServerInstance lastLocation, ZooLock zooLock, boolean insertDeleteFlags) throws IOException {
        if (insertDeleteFlags) {
            MetadataTableUtil.addDeleteEntries(extent, datafilesToDelete, context);
        }
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (FileRef pathToRemove : datafilesToDelete) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, pathToRemove.meta());
        }
        for (FileRef scanFile : scanFiles) {
            m.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, scanFile.meta(), new Value(new byte[0]));
        }
        if (size.getNumEntries() > 0L) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.meta(), new Value(size.encode()));
        }
        if (compactionId != null) {
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value(("" + compactionId).getBytes()));
        }
        TServerInstance self = MasterMetadataUtil.getTServerInstance(address, zooLock);
        self.putLastLocation(m);
        if (lastLocation != null && !lastLocation.equals(self)) {
            lastLocation.clearLastLocation(m);
        }
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void updateTabletDataFile(ClientContext context, KeyExtent extent, FileRef path, FileRef mergeFile, DataFileValue dfv, String time, Set<FileRef> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        if (extent.isRootTablet()) {
            if (unusedWalLogs != null) {
                MasterMetadataUtil.updateRootTabletDataFile(extent, path, mergeFile, dfv, time, filesInUseByScans, address, zooLock, unusedWalLogs, lastLocation, flushId);
            }
            return;
        }
        Mutation m = MasterMetadataUtil.getUpdateForTabletDataFile(extent, path, mergeFile, dfv, time, filesInUseByScans, address, zooLock, unusedWalLogs, lastLocation, flushId);
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    protected static void updateRootTabletDataFile(KeyExtent extent, FileRef path, FileRef mergeFile, DataFileValue dfv, String time, Set<FileRef> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        String root = MetadataTableUtil.getZookeeperLogLocation();
        boolean foundEntry = false;
        block3: for (String entry : unusedWalLogs) {
            String[] parts = entry.split("/");
            String zpath = root + "/" + parts[parts.length - 1];
            while (true) {
                try {
                    if (!zk.exists(zpath)) continue block3;
                    zk.recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
                    foundEntry = true;
                    continue block3;
                }
                catch (KeeperException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
                catch (InterruptedException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
                UtilWaitThread.sleep((long)1000L);
            }
        }
        if (unusedWalLogs.size() > 0 && !foundEntry) {
            log.warn("WALog entry for root tablet did not exist " + unusedWalLogs);
        }
    }

    protected static Mutation getUpdateForTabletDataFile(KeyExtent extent, FileRef path, FileRef mergeFile, DataFileValue dfv, String time, Set<FileRef> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        if (dfv.getNumEntries() > 0L) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.meta(), new Value(dfv.encode()));
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes(StandardCharsets.UTF_8)));
            TServerInstance self = MasterMetadataUtil.getTServerInstance(address, zooLock);
            self.putLastLocation(m);
            if (lastLocation != null && !lastLocation.equals(self)) {
                lastLocation.clearLastLocation(m);
            }
        }
        if (unusedWalLogs != null) {
            for (String entry : unusedWalLogs) {
                m.putDelete(MetadataSchema.TabletsSection.LogColumnFamily.NAME, new Text(entry));
            }
        }
        for (FileRef scanFile : filesInUseByScans) {
            m.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, scanFile.meta(), new Value(new byte[0]));
        }
        if (mergeFile != null) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, mergeFile.meta());
        }
        MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value(Long.toString(flushId).getBytes(StandardCharsets.UTF_8)));
        return m;
    }
}

