/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Halt {
    private static final Logger log = LoggerFactory.getLogger(Halt.class);

    public static void halt(final String msg) {
        Halt.halt(0, new Runnable(){

            @Override
            public void run() {
                log.error("FATAL {}", (Object)msg);
            }
        });
    }

    public static void halt(final String msg, int status) {
        Halt.halt(status, new Runnable(){

            @Override
            public void run() {
                log.error("FATAL {}", (Object)msg);
            }
        });
    }

    public static void halt(final int status, Runnable runnable) {
        try {
            new Daemon(){

                public void run() {
                    UtilWaitThread.sleep((long)100L);
                    Runtime.getRuntime().halt(status);
                }
            }.start();
            if (runnable != null) {
                runnable.run();
            }
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(-1);
        }
    }
}

