/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanZookeeper {
    private static final Logger log = LoggerFactory.getLogger(CleanZookeeper.class);

    public static void main(String[] args) throws IOException {
        Opts opts = new Opts();
        opts.parseArgs(CleanZookeeper.class.getName(), args, new Object[0]);
        String root = "/accumulo";
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        if (opts.auth != null) {
            zk.getZooKeeper().addAuthInfo("digest", ("accumulo:" + opts.auth).getBytes(StandardCharsets.UTF_8));
        }
        try {
            for (String child : zk.getChildren(root)) {
                if ("/instances".equals("/" + child)) {
                    for (String instanceName : zk.getChildren(root + "/instances")) {
                        String instanceNamePath = root + "/instances" + "/" + instanceName;
                        byte[] id = zk.getData(instanceNamePath, null);
                        if (id == null || new String(id, StandardCharsets.UTF_8).equals(HdfsZooInstance.getInstance().getInstanceID())) continue;
                        try {
                            zk.recursiveDelete(instanceNamePath, ZooUtil.NodeMissingPolicy.SKIP);
                        }
                        catch (KeeperException.NoAuthException ex) {
                            log.warn("Unable to delete " + instanceNamePath);
                        }
                    }
                    continue;
                }
                if (child.equals(HdfsZooInstance.getInstance().getInstanceID())) continue;
                String path = root + "/" + child;
                try {
                    zk.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
                }
                catch (KeeperException.NoAuthException ex) {
                    log.warn("Unable to delete " + path);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error Occurred: " + ex);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--password"}, description="The system secret, if different than instance.secret in accumulo-site.xml", password=true)
        String auth;

        Opts() {
        }
    }
}

