/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.hadoop.io.Text;

public class CheckForMetadataProblems {
    private static boolean sawProblems = false;

    public static void checkTable(String tablename, TreeSet<KeyExtent> tablets, ClientOpts opts) throws AccumuloSecurityException {
        if (tablets.size() == 0) {
            System.out.println("No entries found in metadata table for table " + tablename);
            sawProblems = true;
            return;
        }
        if (tablets.first().getPrevEndRow() != null) {
            System.out.println("First entry for table " + tablename + "- " + tablets.first() + " - has non null prev end row");
            sawProblems = true;
            return;
        }
        if (tablets.last().getEndRow() != null) {
            System.out.println("Last entry for table " + tablename + "- " + tablets.last() + " - has non null end row");
            sawProblems = true;
            return;
        }
        Iterator<KeyExtent> tabIter = tablets.iterator();
        Text lastEndRow = tabIter.next().getEndRow();
        boolean everythingLooksGood = true;
        while (tabIter.hasNext()) {
            KeyExtent tabke = tabIter.next();
            boolean broke = false;
            if (tabke.getPrevEndRow() == null) {
                System.out.println("Table " + tablename + " has null prev end row in middle of table " + tabke);
                broke = true;
            } else if (!tabke.getPrevEndRow().equals((Object)lastEndRow)) {
                System.out.println("Table " + tablename + " has a hole " + tabke.getPrevEndRow() + " != " + lastEndRow);
                broke = true;
            }
            if (broke) {
                everythingLooksGood = false;
            }
            lastEndRow = tabke.getEndRow();
        }
        if (everythingLooksGood) {
            System.out.println("All is well for table " + tablename);
        } else {
            sawProblems = true;
        }
    }

    public static void checkMetadataAndRootTableEntries(String tableNameToCheck, ClientOpts opts, VolumeManager fs) throws Exception {
        System.out.println("Checking table: " + tableNameToCheck);
        HashMap tables = new HashMap();
        Scanner scanner = opts.getConnector().createScanner(tableNameToCheck, Authorizations.EMPTY);
        scanner.setRange(MetadataSchema.TabletsSection.getRange());
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        Text colf = new Text();
        Text colq = new Text();
        boolean justLoc = false;
        int count = 0;
        for (Map.Entry entry : scanner) {
            colf = ((Key)entry.getKey()).getColumnFamily(colf);
            colq = ((Key)entry.getKey()).getColumnQualifier(colq);
            ++count;
            String tableName = new KeyExtent(((Key)entry.getKey()).getRow(), (Text)null).getTableId().toString();
            TreeSet<KeyExtent> tablets = (TreeSet<KeyExtent>)tables.get(tableName);
            if (tablets == null) {
                Set es = tables.entrySet();
                for (Map.Entry entry2 : es) {
                    CheckForMetadataProblems.checkTable((String)entry2.getKey(), (TreeSet)entry2.getValue(), opts);
                }
                tables.clear();
                tablets = new TreeSet<KeyExtent>();
                tables.put(tableName, tablets);
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(colf, colq)) {
                KeyExtent tabletKe = new KeyExtent(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
                tablets.add(tabletKe);
                justLoc = false;
                continue;
            }
            if (!colf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) continue;
            if (justLoc) {
                System.out.println("Problem at key " + entry.getKey());
                sawProblems = true;
            }
            justLoc = true;
        }
        if (count == 0) {
            System.err.println("ERROR : " + tableNameToCheck + " table is empty");
            sawProblems = true;
        }
        Set es = tables.entrySet();
        for (Map.Entry entry : es) {
            CheckForMetadataProblems.checkTable((String)entry.getKey(), (TreeSet)entry.getValue(), opts);
        }
        if (!sawProblems) {
            System.out.println("No problems found");
        }
    }

    public static void main(String[] args) throws Exception {
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(CheckForMetadataProblems.class.getName(), args, new Object[0]);
        VolumeManager fs = VolumeManagerImpl.get();
        CheckForMetadataProblems.checkMetadataAndRootTableEntries("accumulo.root", opts, fs);
        CheckForMetadataProblems.checkMetadataAndRootTableEntries("accumulo.metadata", opts, fs);
        opts.stopTracing();
        if (sawProblems) {
            throw new RuntimeException();
        }
    }
}

