/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.tabletserver.MemoryManagementActions;
import org.apache.accumulo.server.tabletserver.MemoryManager;
import org.apache.accumulo.server.tabletserver.TabletState;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargestFirstMemoryManager
implements MemoryManager {
    private static final Logger log = LoggerFactory.getLogger(LargestFirstMemoryManager.class);
    private static final long ZERO_TIME = System.currentTimeMillis();
    private static final int TSERV_MINC_MAXCONCURRENT_NUMWAITING_MULTIPLIER = 2;
    private static final double MAX_FLUSH_AT_ONCE_PERCENT = 0.2;
    private long maxMemory = -1L;
    private int maxConcurrentMincs;
    private int numWaitingMultiplier;
    private long prevIngestMemory = 0L;
    private double compactionThreshold = 0.5;
    private long maxObserved = 0L;
    private final HashMap<Text, Long> mincIdleThresholds = new HashMap();
    private ServerConfiguration config = null;

    LargestFirstMemoryManager(long maxMemory, int maxConcurrentMincs, int numWaitingMultiplier) {
        this();
        this.maxMemory = maxMemory;
        this.maxConcurrentMincs = maxConcurrentMincs;
        this.numWaitingMultiplier = numWaitingMultiplier;
    }

    @Override
    public void init(ServerConfiguration conf) {
        this.config = conf;
        this.maxMemory = conf.getConfiguration().getMemoryInBytes(Property.TSERV_MAXMEM);
        this.maxConcurrentMincs = conf.getConfiguration().getCount(Property.TSERV_MINC_MAXCONCURRENT);
        this.numWaitingMultiplier = 2;
    }

    public LargestFirstMemoryManager() {
    }

    protected long getMinCIdleThreshold(KeyExtent extent) {
        Text tableId = extent.getTableId();
        if (!this.mincIdleThresholds.containsKey(tableId)) {
            this.mincIdleThresholds.put(tableId, this.config.getTableConfiguration(tableId.toString()).getTimeInMillis(Property.TABLE_MINC_COMPACT_IDLETIME));
        }
        return this.mincIdleThresholds.get(tableId);
    }

    protected boolean tableExists(Instance instance, String tableId) {
        return Tables.exists((Instance)instance, (String)tableId);
    }

    @Override
    public MemoryManagementActions getMemoryManagementActions(List<TabletState> tablets) {
        MemoryManagementActions result;
        block22: {
            if (this.maxMemory < 0L) {
                throw new IllegalStateException("need to initialize " + LargestFirstMemoryManager.class.getName());
            }
            Instance instance = this.config.getInstance();
            int maxMinCs = this.maxConcurrentMincs * this.numWaitingMultiplier;
            this.mincIdleThresholds.clear();
            result = new MemoryManagementActions();
            result.tabletsToMinorCompact = new ArrayList<KeyExtent>();
            LargestMap largestMemTablets = new LargestMap(maxMinCs);
            LargestMap largestIdleMemTablets = new LargestMap(this.maxConcurrentMincs);
            long now = this.currentTimeMillis();
            long ingestMemory = 0L;
            long compactionMemory = 0L;
            int numWaitingMincs = 0;
            for (TabletState ts : tablets) {
                if (!this.tableExists(instance, ts.getExtent().getTableId().toString())) {
                    log.trace("Ignoring extent for deleted table: {}", (Object)ts.getExtent());
                    continue;
                }
                long memTabletSize = ts.getMemTableSize();
                long minorCompactingSize = ts.getMinorCompactingMemTableSize();
                long idleTime = now - Math.max(ts.getLastCommitTime(), ZERO_TIME);
                long timeMemoryLoad = LargestFirstMemoryManager.timeMemoryLoad(memTabletSize, idleTime);
                ingestMemory += memTabletSize;
                if (minorCompactingSize == 0L && memTabletSize > 0L) {
                    TabletInfo tabletInfo = new TabletInfo(ts.getExtent(), memTabletSize, idleTime, timeMemoryLoad);
                    try {
                        if (idleTime > this.getMinCIdleThreshold(ts.getExtent())) {
                            largestIdleMemTablets.put(timeMemoryLoad, tabletInfo);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Throwable cause = e.getCause();
                        if (null != cause && cause instanceof TableNotFoundException) {
                            log.trace("Ignoring extent for deleted table: {}", (Object)ts.getExtent());
                            continue;
                        }
                        throw e;
                    }
                    largestMemTablets.put(timeMemoryLoad, tabletInfo);
                }
                compactionMemory += minorCompactingSize;
                if (minorCompactingSize <= 0L) continue;
                ++numWaitingMincs;
            }
            if (ingestMemory + compactionMemory > this.maxObserved) {
                this.maxObserved = ingestMemory + compactionMemory;
            }
            long memoryChange = ingestMemory - this.prevIngestMemory;
            this.prevIngestMemory = ingestMemory;
            boolean startMinC = false;
            if (numWaitingMincs < maxMinCs) {
                if (memoryChange >= 0L && (double)(ingestMemory + memoryChange) > this.compactionThreshold * (double)this.maxMemory) {
                    startMinC = true;
                } else if (!largestIdleMemTablets.isEmpty()) {
                    startMinC = true;
                    largestMemTablets = largestIdleMemTablets;
                    log.debug("IDLE minor compaction chosen");
                }
            }
            if (startMinC) {
                long toBeCompacted = compactionMemory;
                int i = numWaitingMincs;
                while (i < maxMinCs && !largestMemTablets.isEmpty()) {
                    Map.Entry<Long, List<TabletInfo>> lastEntry = largestMemTablets.lastEntry();
                    for (TabletInfo largest : lastEntry.getValue()) {
                        result.tabletsToMinorCompact.add(largest.extent);
                        log.debug(String.format("COMPACTING %s  total = %,d ingestMemory = %,d", largest.extent.toString(), ingestMemory + compactionMemory, ingestMemory));
                        log.debug(String.format("chosenMem = %,d chosenIT = %.2f load %,d", largest.memTableSize, (double)largest.idleTime / 1000.0, largest.load));
                        if (!((double)(toBeCompacted += largest.memTableSize) > (double)ingestMemory * 0.2)) {
                            ++i;
                            continue;
                        }
                        break block22;
                    }
                    largestMemTablets.remove(lastEntry.getKey());
                }
            } else if (memoryChange < 0L) {
                log.debug(String.format("BEFORE compactionThreshold = %.3f maxObserved = %,d", this.compactionThreshold, this.maxObserved));
                if (this.compactionThreshold < 0.82 && (double)this.maxObserved < 0.8 * (double)this.maxMemory) {
                    this.compactionThreshold *= 1.1;
                } else if (this.compactionThreshold > 0.056 && (double)this.maxObserved > 0.9 * (double)this.maxMemory) {
                    this.compactionThreshold *= 0.9;
                }
                this.maxObserved = 0L;
                log.debug(String.format("AFTER compactionThreshold = %.3f", this.compactionThreshold));
            }
        }
        return result;
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public void tabletClosed(KeyExtent extent) {
    }

    static long timeMemoryLoad(long mem, long time) {
        double minutesIdle = (double)time / 60000.0;
        return (long)((double)mem * Math.pow(2.0, minutesIdle / 15.0));
    }

    private static class LargestMap {
        final int max;
        final TreeMap<Long, List<TabletInfo>> map = new TreeMap();

        LargestMap(int n) {
            this.max = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(Long key, TabletInfo value) {
            if (this.map.size() == this.max) {
                if (key.compareTo(this.map.firstKey()) < 0) {
                    return false;
                }
                try {
                    this.add(key, value);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.map.remove(this.map.firstKey());
                }
            }
            this.add(key, value);
            return true;
        }

        private void add(Long key, TabletInfo value) {
            List<TabletInfo> lst = this.map.get(key);
            if (lst != null) {
                lst.add(value);
            } else {
                lst = new ArrayList<TabletInfo>();
                lst.add(value);
                this.map.put(key, lst);
            }
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Map.Entry<Long, List<TabletInfo>> lastEntry() {
            return this.map.lastEntry();
        }

        public void remove(Long key) {
            this.map.remove(key);
        }
    }

    private static class TabletInfo {
        final KeyExtent extent;
        final long memTableSize;
        final long idleTime;
        final long load;

        public TabletInfo(KeyExtent extent, long memTableSize, long idleTime, long load) {
            this.extent = extent;
            this.memTableSize = memTableSize;
            this.idleTime = idleTime;
            this.load = load;
        }
    }
}

