/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNonblockingServerSocket
extends TNonblockingServerTransport {
    private static final Logger log = LoggerFactory.getLogger(TNonblockingServerSocket.class);
    private ServerSocketChannel serverSocketChannel = null;
    private ServerSocket serverSocket_ = null;
    private int clientTimeout_ = 0;

    public TNonblockingServerSocket(int port, int clientTimeout) throws TTransportException {
        this(new InetSocketAddress(port), clientTimeout);
    }

    public TNonblockingServerSocket(InetSocketAddress bindAddr) throws TTransportException {
        this(bindAddr, 0);
    }

    public TNonblockingServerSocket(InetSocketAddress bindAddr, int clientTimeout) throws TTransportException {
        this.clientTimeout_ = clientTimeout;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocket_ = this.serverSocketChannel.socket();
            this.serverSocket_.setReuseAddress(true);
            this.serverSocket_.bind(bindAddr);
        }
        catch (IOException ioe) {
            this.serverSocket_ = null;
            throw new TTransportException("Could not create ServerSocket on address " + bindAddr.toString() + ".");
        }
    }

    public void listen() throws TTransportException {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.setSoTimeout(0);
            }
            catch (SocketException sx) {
                log.error("SocketException caused by serverSocket in listen()", (Throwable)sx);
            }
        }
    }

    protected TNonblockingSocket acceptImpl() throws TTransportException {
        if (this.serverSocket_ == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        try {
            SocketChannel socketChannel = this.serverSocketChannel.accept();
            if (socketChannel == null) {
                return null;
            }
            TNonblockingSocket tsocket = new TNonblockingSocket(socketChannel);
            tsocket.setTimeout(this.clientTimeout_);
            return tsocket;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public void registerSelector(Selector selector) {
        try {
            this.serverSocketChannel.register(selector, 16);
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.close();
            }
            catch (IOException iox) {
                log.warn("WARNING: Could not close server socket: {}", (Object)iox.getMessage());
            }
            this.serverSocket_ = null;
        }
    }

    public void interrupt() {
        this.close();
    }

    public int getPort() {
        return this.serverSocket_.getLocalPort();
    }
}

