/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import com.google.common.base.Function;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.server.master.balancer.GroupBalancer;
import org.apache.hadoop.io.Text;

public class RegexGroupBalancer
extends GroupBalancer {
    public static final String REGEX_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.pattern";
    public static final String DEFAUT_GROUP_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.default";
    public static final String WAIT_TIME_PROPERTY = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "balancer.group.regex.wait.time";
    private final String tableId;

    public RegexGroupBalancer(String tableId) {
        super(tableId);
        this.tableId = tableId;
    }

    @Override
    protected long getWaitTime() {
        Map customProps = this.configuration.getTableConfiguration(this.tableId).getAllPropertiesWithPrefix(Property.TABLE_ARBITRARY_PROP_PREFIX);
        if (customProps.containsKey(WAIT_TIME_PROPERTY)) {
            return AccumuloConfiguration.getTimeInMillis((String)((String)customProps.get(WAIT_TIME_PROPERTY)));
        }
        return super.getWaitTime();
    }

    @Override
    protected Function<KeyExtent, String> getPartitioner() {
        Map customProps = this.configuration.getTableConfiguration(this.tableId).getAllPropertiesWithPrefix(Property.TABLE_ARBITRARY_PROP_PREFIX);
        String regex = (String)customProps.get(REGEX_PROPERTY);
        final String defaultGroup = (String)customProps.get(DEFAUT_GROUP_PROPERTY);
        final Pattern pattern = Pattern.compile(regex);
        return new Function<KeyExtent, String>(){

            public String apply(KeyExtent input) {
                Text er = input.getEndRow();
                if (er == null) {
                    return defaultGroup;
                }
                Matcher matcher = pattern.matcher(er.toString());
                if (matcher.matches() && matcher.groupCount() == 1) {
                    return matcher.group(1);
                }
                return defaultGroup;
            }
        };
    }
}

