/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.volume.NonConfiguredVolume;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.server.fs.PerTableVolumeChooser;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.server.fs.ViewFSUtils;
import org.apache.accumulo.server.fs.VolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeManagerImpl
implements VolumeManager {
    private static final Logger log = LoggerFactory.getLogger(VolumeManagerImpl.class);
    private static final HashSet<String> WARNED_ABOUT_SYNCONCLOSE = new HashSet();
    Map<String, Volume> volumesByName;
    Multimap<URI, Volume> volumesByFileSystemUri;
    Volume defaultVolume;
    AccumuloConfiguration conf;
    VolumeChooser chooser;
    private static final String DEFAULT = "";
    private static final String RFILE_SUFFIX = ".rf";
    private final VolumeChooser failsafeChooser = new RandomVolumeChooser();

    protected VolumeManagerImpl(Map<String, Volume> volumes, Volume defaultVolume, AccumuloConfiguration conf) {
        this.volumesByName = volumes;
        this.defaultVolume = defaultVolume;
        this.volumesByFileSystemUri = HashMultimap.create();
        this.invertVolumesByFileSystem(this.volumesByName, this.volumesByFileSystemUri);
        this.conf = conf;
        this.ensureSyncIsEnabled();
        this.chooser = (VolumeChooser)Property.createInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.GENERAL_VOLUME_CHOOSER, VolumeChooser.class, (Object)new PerTableVolumeChooser());
    }

    private void invertVolumesByFileSystem(Map<String, Volume> forward, Multimap<URI, Volume> inverted) {
        for (Volume volume : forward.values()) {
            inverted.put((Object)volume.getFileSystem().getUri(), (Object)volume);
        }
    }

    public static VolumeManager getLocal(String localBasePath) throws IOException {
        DefaultConfiguration accConf = DefaultConfiguration.getDefaultConfiguration();
        Volume defaultLocalVolume = VolumeConfiguration.create((FileSystem)FileSystem.getLocal((Configuration)CachedConfiguration.getInstance()), (String)localBasePath);
        return new VolumeManagerImpl(Collections.singletonMap(DEFAULT, defaultLocalVolume), defaultLocalVolume, (AccumuloConfiguration)accConf);
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (Volume volume : this.volumesByName.values()) {
            try {
                volume.getFileSystem().close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public FSDataOutputStream create(Path path) throws IOException {
        Objects.requireNonNull(path);
        Volume v = this.getVolumeByPath(path);
        return v.getFileSystem().create(path);
    }

    @Override
    public FSDataOutputStream create(Path path, boolean overwrite) throws IOException {
        Objects.requireNonNull(path);
        Volume v = this.getVolumeByPath(path);
        return v.getFileSystem().create(path, overwrite);
    }

    private static long correctBlockSize(Configuration conf, long blockSize) {
        if (blockSize <= 0L) {
            blockSize = conf.getLong("dfs.block.size", 0x4000000L);
        }
        int checkSum = conf.getInt("io.bytes.per.checksum", 512);
        blockSize -= blockSize % (long)checkSum;
        blockSize = Math.max(blockSize, (long)checkSum);
        return blockSize;
    }

    private static int correctBufferSize(Configuration conf, int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = conf.getInt("io.file.buffer.size", 4096);
        }
        return bufferSize;
    }

    @Override
    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        Objects.requireNonNull(path);
        Volume v = this.getVolumeByPath(path);
        FileSystem fs = v.getFileSystem();
        blockSize = VolumeManagerImpl.correctBlockSize(fs.getConf(), blockSize);
        bufferSize = VolumeManagerImpl.correctBufferSize(fs.getConf(), bufferSize);
        return fs.create(path, overwrite, bufferSize, replication, blockSize);
    }

    @Override
    public boolean createNewFile(Path path) throws IOException {
        Objects.requireNonNull(path);
        Volume v = this.getVolumeByPath(path);
        return v.getFileSystem().createNewFile(path);
    }

    @Override
    public FSDataOutputStream createSyncable(Path logPath, int bufferSize, short replication, long blockSize) throws IOException {
        Volume v = this.getVolumeByPath(logPath);
        FileSystem fs = v.getFileSystem();
        blockSize = VolumeManagerImpl.correctBlockSize(fs.getConf(), blockSize);
        bufferSize = VolumeManagerImpl.correctBufferSize(fs.getConf(), bufferSize);
        EnumSet<CreateFlag> set = EnumSet.of(CreateFlag.SYNC_BLOCK, CreateFlag.CREATE);
        log.debug("creating " + logPath + " with CreateFlag set: " + set);
        try {
            return fs.create(logPath, FsPermission.getDefault(), set, bufferSize, replication, blockSize, null);
        }
        catch (Exception ex) {
            log.debug("Exception", (Throwable)ex);
            return fs.create(logPath, true, bufferSize, replication, blockSize);
        }
    }

    @Override
    public boolean delete(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().delete(path, false);
    }

    @Override
    public boolean deleteRecursively(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().delete(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureSyncIsEnabled() {
        for (Map.Entry<String, Volume> entry : this.getFileSystems().entrySet()) {
            FileSystem fs = entry.getValue().getFileSystem();
            if (!(fs instanceof DistributedFileSystem)) continue;
            String DFS_SUPPORT_APPEND = "dfs.support.append";
            String DFS_DATANODE_SYNCONCLOSE = "dfs.datanode.synconclose";
            String ticketMessage = "See ACCUMULO-623 and ACCUMULO-1637 for more details.";
            if (!fs.getConf().getBoolean("dfs.support.append", true)) {
                String msg = "Accumulo requires that dfs.support.append not be configured as false. See ACCUMULO-623 and ACCUMULO-1637 for more details.";
                log.error("FATAL {}", (Object)msg);
                throw new RuntimeException(msg);
            }
            if (fs.getConf().getBoolean("dfs.datanode.synconclose", false)) continue;
            HashSet<String> hashSet = WARNED_ABOUT_SYNCONCLOSE;
            synchronized (hashSet) {
                if (!WARNED_ABOUT_SYNCONCLOSE.contains(entry.getKey())) {
                    WARNED_ABOUT_SYNCONCLOSE.add(entry.getKey());
                    log.warn("dfs.datanode.synconclose set to false in hdfs-site.xml: data loss is possible on hard system reset or power loss");
                }
            }
        }
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().exists(path);
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().getFileStatus(path);
    }

    @Override
    public Volume getVolumeByPath(Path path) {
        if (path.toString().contains(":")) {
            try {
                FileSystem desiredFs = path.getFileSystem(CachedConfiguration.getInstance());
                URI desiredFsUri = desiredFs.getUri();
                Collection candidateVolumes = this.volumesByFileSystemUri.get((Object)desiredFsUri);
                if (null != candidateVolumes) {
                    for (Volume candidateVolume : candidateVolumes) {
                        if (!candidateVolume.isValidPath(path)) continue;
                        return candidateVolume;
                    }
                    log.debug("Found candidate Volumes for Path but none of the Volumes are valid for the candidates: " + path);
                } else {
                    log.debug("Could not determine volume for Path: " + path);
                }
                return new NonConfiguredVolume(desiredFs);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.defaultVolume;
    }

    private Map<String, Volume> getFileSystems() {
        return this.volumesByName;
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().listStatus(path);
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().mkdirs(path);
    }

    @Override
    public FSDataInputStream open(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().open(path);
    }

    @Override
    public boolean rename(Path path, Path newPath) throws IOException {
        FileSystem dest;
        Volume srcVolume = this.getVolumeByPath(path);
        Volume destVolume = this.getVolumeByPath(newPath);
        FileSystem source = srcVolume.getFileSystem();
        if (source != (dest = destVolume.getFileSystem())) {
            throw new NotImplementedException("Cannot rename files across volumes: " + path + " -> " + newPath);
        }
        return source.rename(path, newPath);
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        FileSystem fs = this.getVolumeByPath(path).getFileSystem();
        Trash trash = new Trash(fs, fs.getConf());
        return trash.moveToTrash(path);
    }

    @Override
    public short getDefaultReplication(Path path) {
        Volume v = this.getVolumeByPath(path);
        return v.getFileSystem().getDefaultReplication(path);
    }

    @Override
    public boolean isFile(Path path) throws IOException {
        return this.getVolumeByPath(path).getFileSystem().isFile(path);
    }

    public static VolumeManager get() throws IOException {
        SiteConfiguration conf = SiteConfiguration.getInstance();
        return VolumeManagerImpl.get((AccumuloConfiguration)conf);
    }

    public static VolumeManager get(AccumuloConfiguration conf) throws IOException {
        return VolumeManagerImpl.get(conf, CachedConfiguration.getInstance());
    }

    public static VolumeManager get(AccumuloConfiguration conf, Configuration hadoopConf) throws IOException {
        HashMap<String, Volume> volumes = new HashMap<String, Volume>();
        for (String volumeUriOrDir : VolumeConfiguration.getVolumeUris((AccumuloConfiguration)conf, (Configuration)hadoopConf)) {
            if (volumeUriOrDir.equals(DEFAULT)) {
                throw new IllegalArgumentException("Cannot re-define the default volume");
            }
            if (volumeUriOrDir.startsWith("viewfs")) {
                throw new IllegalArgumentException("Cannot use viewfs as a volume");
            }
            if (!volumeUriOrDir.contains(":")) {
                throw new IllegalArgumentException("Expected fully qualified URI for " + Property.INSTANCE_VOLUMES.getKey() + " got " + volumeUriOrDir);
            }
            volumes.put(volumeUriOrDir, VolumeConfiguration.create((Path)new Path(volumeUriOrDir), (Configuration)hadoopConf));
        }
        return new VolumeManagerImpl(volumes, VolumeConfiguration.getDefaultVolume((Configuration)hadoopConf, (AccumuloConfiguration)conf), conf);
    }

    @Override
    public boolean isReady() throws IOException {
        for (Volume volume : this.getFileSystems().values()) {
            DistributedFileSystem dfs;
            FileSystem fs = volume.getFileSystem();
            if (!(fs instanceof DistributedFileSystem) || !(dfs = (DistributedFileSystem)fs).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.getVolumeByPath(pathPattern).getFileSystem().globStatus(pathPattern);
    }

    @Override
    public Path getFullPath(Key key) {
        String relPath = key.getColumnQualifierData().toString();
        byte[] tableId = KeyExtent.tableOfMetadataRow((Text)key.getRow());
        return this.getFullPath(new String(tableId), relPath);
    }

    @Override
    public Path matchingFileSystem(Path source, String[] options) {
        try {
            if (ViewFSUtils.isViewFS(source, CachedConfiguration.getInstance())) {
                return ViewFSUtils.matchingFileSystem(source, options, CachedConfiguration.getInstance());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        URI uri1 = source.toUri();
        for (String option : options) {
            URI uri3 = URI.create(option);
            if (!uri1.getScheme().equals(uri3.getScheme())) continue;
            String a1 = uri1.getAuthority();
            String a2 = uri3.getAuthority();
            if ((a1 != null || a2 != null) && (a1 == null || !a1.equals(a2))) continue;
            return new Path(option);
        }
        return null;
    }

    @Override
    public Path getFullPath(String tableId, String path) {
        if (path.contains(":")) {
            return new Path(path);
        }
        if (path.startsWith("../")) {
            path = path.substring(2);
        } else if (path.startsWith("/")) {
            path = "/" + tableId + path;
        } else {
            throw new IllegalArgumentException("Unexpected path prefix " + path);
        }
        return this.getFullPath(VolumeManager.FileType.TABLE, path);
    }

    @Override
    public Path getFullPath(VolumeManager.FileType fileType, String path) {
        int colon = path.indexOf(58);
        if (colon > -1) {
            if (fileType == VolumeManager.FileType.WAL && path.charAt(colon + 1) != '/') {
                path = path.substring(path.indexOf(47));
            } else {
                return new Path(path);
            }
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (VolumeManager.FileType.TABLE == fileType) {
            String[] pathComponents = StringUtils.split((String)path, (char)'/');
            if (path.endsWith(RFILE_SUFFIX)) {
                if (pathComponents.length < 3) {
                    throw new IllegalArgumentException("Fewer components in file path than expected");
                }
            } else if (pathComponents.length < 2) {
                throw new IllegalArgumentException("Fewer components in directory path than expected");
            }
        }
        Path fullPath = new Path(this.defaultVolume.getBasePath(), fileType.getDirectory());
        fullPath = new Path(fullPath, path);
        FileSystem fs = this.getVolumeByPath(fullPath).getFileSystem();
        return fs.makeQualified(fullPath);
    }

    @Override
    public ContentSummary getContentSummary(Path dir) throws IOException {
        return this.getVolumeByPath(dir).getFileSystem().getContentSummary(dir);
    }

    @Override
    public String choose(Optional<String> tableId, String[] options) {
        VolumeChooserEnvironment env = new VolumeChooserEnvironment(tableId);
        String choice = this.chooser.choose(env, options);
        if (!ArrayUtils.contains((Object[])options, (Object)choice)) {
            log.error("The configured volume chooser, '" + this.chooser.getClass() + "', or one of its delegates returned a volume not in the set of options provided; " + "will continue by relying on a RandomVolumeChooser. You should investigate and correct the named chooser.");
            return this.failsafeChooser.choose(env, options);
        }
        return choice;
    }

    @Override
    public Volume getDefaultVolume() {
        return this.defaultVolume;
    }

    @Override
    public Collection<Volume> getVolumes() {
        return this.volumesByName.values();
    }
}

