/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfWatcher;
import org.apache.accumulo.server.conf.ZooCachePropertyAccessor;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfiguration
extends ObservableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TableConfiguration.class);
    private static final Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> propCaches = new HashMap<ZooCachePropertyAccessor.PropCacheKey, ZooCache>();
    private ZooCachePropertyAccessor propCacheAccessor = null;
    private final Instance instance;
    private final NamespaceConfiguration parent;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private final String table;

    public TableConfiguration(Instance instance, String table, NamespaceConfiguration parent) {
        this.instance = instance;
        this.table = table;
        this.parent = parent;
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ZooCachePropertyAccessor getPropCacheAccessor() {
        if (this.propCacheAccessor == null) {
            Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> map = propCaches;
            synchronized (map) {
                ZooCachePropertyAccessor.PropCacheKey key = new ZooCachePropertyAccessor.PropCacheKey(this.instance.getInstanceID(), this.table);
                ZooCache propCache = propCaches.get(key);
                if (propCache == null) {
                    propCache = this.zcf.getZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut(), (Watcher)new TableConfWatcher(this.instance));
                    propCaches.put(key, propCache);
                }
                this.propCacheAccessor = new ZooCachePropertyAccessor(propCache);
            }
        }
        return this.propCacheAccessor;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.table == null) {
            String err = "Attempt to add observer for non-table configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        this.iterator();
        super.addObserver(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        if (this.table == null) {
            String err = "Attempt to remove observer for non-table configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        super.removeObserver(co);
    }

    private String getPath() {
        return ZooUtil.getRoot((String)this.instance.getInstanceID()) + "/tables" + "/" + this.table + "/conf";
    }

    public String get(Property property) {
        return this.getPropCacheAccessor().get(property, this.getPath(), (AccumuloConfiguration)this.parent);
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.getPropCacheAccessor().getProperties(props, this.getPath(), filter, (AccumuloConfiguration)this.parent, null);
    }

    public String getTableId() {
        return this.table;
    }

    public NamespaceConfiguration getNamespaceConfiguration() {
        return new ServerConfigurationFactory(this.parent.inst).getNamespaceConfiguration(this.parent.namespaceId);
    }

    public NamespaceConfiguration getParentConfiguration() {
        return this.parent;
    }

    public synchronized void invalidateCache() {
        if (null != this.propCacheAccessor) {
            this.propCacheAccessor.invalidateCache();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

