/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterServerType;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;

public class MiniAccumuloCluster {
    private MiniAccumuloClusterImpl impl;

    private MiniAccumuloCluster(MiniAccumuloConfigImpl config) throws IOException {
        this.impl = new MiniAccumuloClusterImpl(config);
    }

    public MiniAccumuloCluster(File dir, String rootPassword) throws IOException {
        this(new MiniAccumuloConfigImpl(dir, rootPassword));
    }

    public MiniAccumuloCluster(MiniAccumuloConfig config) throws IOException {
        this(config.getImpl());
    }

    public void start() throws IOException, InterruptedException {
        this.impl.start();
    }

    public Set<Pair<ServerType, Integer>> getDebugPorts() {
        Set<Pair<ClusterServerType, Integer>> implPorts = this.impl.getDebugPorts();
        HashSet<Pair<ServerType, Integer>> returnPorts = new HashSet<Pair<ServerType, Integer>>();
        for (Pair<ClusterServerType, Integer> pair : implPorts) {
            ServerType st = ((ClusterServerType)((Object)pair.getFirst())).toServerType();
            if (null == st) continue;
            returnPorts.add((Pair<ServerType, Integer>)new Pair((Object)st, pair.getSecond()));
        }
        return returnPorts;
    }

    public String getInstanceName() {
        return this.impl.getInstanceName();
    }

    public String getZooKeepers() {
        return this.impl.getZooKeepers();
    }

    public void stop() throws IOException, InterruptedException {
        this.impl.stop();
    }

    public MiniAccumuloConfig getConfig() {
        return new MiniAccumuloConfig(this.impl.getConfig());
    }

    public Connector getConnector(String user, String passwd) throws AccumuloException, AccumuloSecurityException {
        return this.impl.getConnector(user, (AuthenticationToken)new PasswordToken((CharSequence)passwd));
    }

    public ClientConfiguration getClientConfig() {
        return this.impl.getClientConfig();
    }
}

