/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.thrift.TInfo;

public class TraceRepo<T>
implements Repo<T> {
    private static final long serialVersionUID = 1L;
    TInfo tinfo;
    Repo<T> repo;

    public TraceRepo(Repo<T> repo) {
        this.repo = repo;
        this.tinfo = Tracer.traceInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long isReady(long tid, T environment) throws Exception {
        Span span = Trace.trace((TInfo)this.tinfo, (String)this.repo.getDescription());
        try {
            long l = this.repo.isReady(tid, environment);
            return l;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repo<T> call(long tid, T environment) throws Exception {
        Span span = Trace.trace((TInfo)this.tinfo, (String)this.repo.getDescription());
        try {
            Repo result = this.repo.call(tid, environment);
            if (result == null) {
                Repo repo = result;
                return repo;
            }
            TraceRepo<T> traceRepo = new TraceRepo<T>(result);
            return traceRepo;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(long tid, T environment) throws Exception {
        Span span = Trace.trace((TInfo)this.tinfo, (String)this.repo.getDescription());
        try {
            this.repo.undo(tid, environment);
        }
        finally {
            span.stop();
        }
    }

    public String getDescription() {
        return this.repo.getDescription();
    }

    public String getReturn() {
        return this.repo.getReturn();
    }
}

