/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableRangeOpWait;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class TableRangeOp
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private byte[] startRow;
    private byte[] endRow;
    private MergeInfo.Operation op;
    private String namespaceId;

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceId, tid, false, true, TableOperation.MERGE) + Utils.reserveTable(this.tableId, tid, true, true, TableOperation.MERGE);
    }

    public TableRangeOp(MergeInfo.Operation op, String tableId, Text startRow, Text endRow) throws ThriftTableOperationException {
        this.tableId = tableId;
        this.startRow = TextUtil.getBytes((Text)startRow);
        this.endRow = TextUtil.getBytes((Text)endRow);
        this.op = op;
        Instance inst = HdfsZooInstance.getInstance();
        this.namespaceId = Tables.getNamespaceId((Instance)inst, (String)tableId);
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        if ("+r".equals(this.tableId) && MergeInfo.Operation.MERGE.equals((Object)this.op)) {
            log.warn((Object)"Attempt to merge tablets for accumulo.root does nothing. It is not splittable.");
        }
        Text start = this.startRow.length == 0 ? null : new Text(this.startRow);
        Text end = this.endRow.length == 0 ? null : new Text(this.endRow);
        Text tableIdText = new Text(this.tableId);
        if (start != null && end != null && start.compareTo((BinaryComparable)end) >= 0) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.MERGE, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        env.mustBeOnline(this.tableId);
        MergeInfo info = env.getMergeInfo(tableIdText);
        if (info.getState() == MergeState.NONE) {
            KeyExtent range = new KeyExtent(tableIdText, end, start);
            env.setMergeState(new MergeInfo(range, this.op), MergeState.STARTED);
        }
        return new TableRangeOpWait(this.tableId);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Text tableIdText = new Text(this.tableId);
        MergeInfo mergeInfo = env.getMergeInfo(tableIdText);
        if (mergeInfo.getState() != MergeState.NONE) {
            log.info((Object)("removing merge information " + mergeInfo));
        }
        env.clearMergeState(tableIdText);
        Utils.unreserveNamespace(this.namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, true);
    }
}

