/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

class CleanUpBulkImport
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CleanUpBulkImport.class);
    private String tableId;
    private String source;
    private String bulk;
    private String error;

    public CleanUpBulkImport(String tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        log.debug((Object)("removing the bulk processing flag file in " + this.bulk));
        Path bulkDir = new Path(this.bulk);
        MetadataTableUtil.removeBulkLoadInProgressFlag((String)("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName()));
        MetadataTableUtil.addDeleteEntry((String)this.tableId, (String)bulkDir.toString());
        log.debug((Object)"removing the metadata table markers for loaded files");
        Connector conn = master.getConnector();
        MetadataTableUtil.removeBulkLoadEntries((Connector)conn, (String)this.tableId, (long)tid);
        log.debug((Object)("releasing HDFS reservations for " + this.source + " and " + this.error));
        Utils.unreserveHdfsDirectory(this.source, tid);
        Utils.unreserveHdfsDirectory(this.error, tid);
        Utils.getReadLock(this.tableId, tid).unlock();
        log.debug((Object)("completing bulk import transaction " + tid));
        TransactionWatcher.ZooArbitrator.cleanup((String)"bulkTx", (long)tid);
        return null;
    }
}

