/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.shard;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.BatchScannerOpts;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.hadoop.io.Text;

public class ContinuousQuery {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        BatchScannerOpts bsOpts = new BatchScannerOpts();
        opts.parseArgs(ContinuousQuery.class.getName(), args, new Object[]{bsOpts});
        Connector conn = opts.getConnector();
        ArrayList<Text[]> randTerms = ContinuousQuery.findRandomTerms(conn.createScanner(opts.doc2Term, opts.auths), opts.numTerms);
        Random rand = new Random();
        BatchScanner bs = conn.createBatchScanner(opts.table, opts.auths, bsOpts.scanThreads.intValue());
        bs.setTimeout(bsOpts.scanTimeout.longValue(), TimeUnit.MILLISECONDS);
        for (long i = 0L; i < opts.iterations; ++i) {
            Text[] columns = randTerms.get(rand.nextInt(randTerms.size()));
            bs.clearScanIterators();
            bs.clearColumns();
            IteratorSetting ii = new IteratorSetting(20, "ii", IntersectingIterator.class);
            IntersectingIterator.setColumnFamilies((IteratorSetting)ii, (Text[])columns);
            bs.addScanIterator(ii);
            bs.setRanges(Collections.singleton(new Range()));
            long t1 = System.currentTimeMillis();
            int count = 0;
            for (Map.Entry entry : bs) {
                ++count;
            }
            long t2 = System.currentTimeMillis();
            System.out.printf("  %s %,d %6.3f%n", Arrays.asList(columns), count, (double)(t2 - t1) / 1000.0);
        }
        bs.close();
    }

    private static ArrayList<Text[]> findRandomTerms(Scanner scanner, int numTerms) {
        Text currentRow = null;
        ArrayList<Text> words = new ArrayList<Text>();
        ArrayList<Text[]> ret = new ArrayList<Text[]>();
        Random rand = new Random();
        for (Map.Entry entry : scanner) {
            Key key = (Key)entry.getKey();
            if (currentRow == null) {
                currentRow = key.getRow();
            }
            if (!currentRow.equals((Object)key.getRow())) {
                ContinuousQuery.selectRandomWords(words, ret, rand, numTerms);
                words.clear();
                currentRow = key.getRow();
            }
            words.add(key.getColumnFamily());
        }
        ContinuousQuery.selectRandomWords(words, ret, rand, numTerms);
        return ret;
    }

    private static void selectRandomWords(ArrayList<Text> words, ArrayList<Text[]> ret, Random rand, int numTerms) {
        if (words.size() >= numTerms) {
            Collections.shuffle(words, rand);
            Text[] docWords = new Text[numTerms];
            for (int i = 0; i < docWords.length; ++i) {
                docWords[i] = words.get(i);
            }
            ret.add(docWords);
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--shardTable"}, required=true, description="name of the shard table")
        String table = null;
        @Parameter(names={"--doc2Term"}, required=true, description="name of the doc2Term table")
        String doc2Term;
        @Parameter(names={"--terms"}, required=true, description="the number of terms in the query")
        int numTerms;
        @Parameter(names={"--count"}, description="the number of queries to run")
        long iterations = Long.MAX_VALUE;

        Opts() {
        }
    }
}

