/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.reservations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;

public class ARS {
    private Connector conn;
    private String rTable;

    public ARS(Connector conn, String rTable) {
        this.conn = conn;
        this.rTable = rTable;
    }

    public List<String> setCapacity(String what, String when, int count) {
        throw new UnsupportedOperationException();
    }

    public ReservationResult reserve(String what, String when, String who) throws Exception {
        String row = what + ":" + when;
        ConditionalMutation update = new ConditionalMutation((CharSequence)row, new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
        update.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"0");
        update.put((CharSequence)"res", (CharSequence)String.format("%04d", 0), (CharSequence)who);
        ReservationResult result = ReservationResult.RESERVED;
        ConditionalWriter cwriter = this.conn.createConditionalWriter(this.rTable, new ConditionalWriterConfig());
        try {
            while (true) {
                ConditionalWriter.Status status = cwriter.write(update).getStatus();
                switch (status) {
                    case ACCEPTED: {
                        ReservationResult reservationResult = result;
                        return reservationResult;
                    }
                    case REJECTED: 
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected status " + status);
                    }
                }
                IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.rTable, Authorizations.EMPTY));
                scanner.setRange(new Range((CharSequence)row));
                int seq = -1;
                int maxReservation = -1;
                for (Map.Entry entry : scanner) {
                    String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
                    String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
                    String val = ((Value)entry.getValue()).toString();
                    if (cf.equals("tx") && cq.equals("seq")) {
                        seq = Integer.parseInt(val);
                        continue;
                    }
                    if (!cf.equals("res")) continue;
                    if (val.equals(who)) {
                        if (maxReservation == -1) {
                            ReservationResult reservationResult = ReservationResult.RESERVED;
                            return reservationResult;
                        }
                        ReservationResult reservationResult = ReservationResult.WAIT_LISTED;
                        return reservationResult;
                    }
                    maxReservation = Integer.parseInt(cq);
                }
                Condition condition = new Condition((CharSequence)"tx", (CharSequence)"seq");
                if (seq >= 0) {
                    condition.setValue((CharSequence)(seq + ""));
                }
                update = new ConditionalMutation((CharSequence)row, new Condition[]{condition});
                update.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)(seq + 1 + ""));
                update.put((CharSequence)"res", (CharSequence)String.format("%04d", maxReservation + 1), (CharSequence)who);
                if (maxReservation == -1) {
                    result = ReservationResult.RESERVED;
                    continue;
                }
                result = ReservationResult.WAIT_LISTED;
            }
        }
        finally {
            cwriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancel(String what, String when, String who) throws Exception {
        String row = what + ":" + when;
        ConditionalWriter cwriter = this.conn.createConditionalWriter(this.rTable, new ConditionalWriterConfig());
        try {
            ConditionalWriter.Status status;
            block8: while (true) {
                IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.rTable, Authorizations.EMPTY));
                scanner.setRange(new Range((CharSequence)row));
                int seq = -1;
                String reservation = null;
                for (Map.Entry entry : scanner) {
                    String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
                    String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
                    String val = ((Value)entry.getValue()).toString();
                    if (cf.equals("tx") && cq.equals("seq")) {
                        seq = Integer.parseInt(val);
                        continue;
                    }
                    if (!cf.equals("res") || !val.equals(who)) continue;
                    reservation = cq;
                }
                if (reservation == null) return;
                ConditionalMutation update = new ConditionalMutation((CharSequence)row, new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)(seq + ""))});
                update.putDelete((CharSequence)"res", reservation);
                update.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)(seq + 1 + ""));
                status = cwriter.write(update).getStatus();
                switch (status) {
                    case ACCEPTED: {
                        return;
                    }
                    case REJECTED: 
                    case UNKNOWN: {
                        continue block8;
                    }
                }
                break;
            }
            throw new RuntimeException("Unexpected status " + status);
        }
        finally {
            cwriter.close();
        }
    }

    public List<String> list(String what, String when) throws Exception {
        String row = what + ":" + when;
        IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.rTable, Authorizations.EMPTY));
        scanner.setRange(new Range((CharSequence)row));
        scanner.fetchColumnFamily(new Text("res"));
        ArrayList<String> reservations = new ArrayList<String>();
        for (Map.Entry entry : scanner) {
            String val = ((Value)entry.getValue()).toString();
            reservations.add(val);
        }
        return reservations;
    }

    public static void main(String[] args) throws Exception {
        String line;
        final ConsoleReader reader = new ConsoleReader();
        ARS ars = null;
        while ((line = reader.readLine(">")) != null) {
            final String[] tokens = line.split("\\s+");
            if (tokens[0].equals("reserve") && tokens.length >= 4 && ars != null) {
                final ARS fars = ars;
                ArrayList<Thread> threads = new ArrayList<Thread>();
                int i = 3;
                while (i < tokens.length) {
                    final int whoIndex = i++;
                    Runnable reservationTask = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                reader.println((CharSequence)("  " + String.format("%20s", tokens[whoIndex]) + " : " + (Object)((Object)fars.reserve(tokens[1], tokens[2], tokens[whoIndex]))));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    threads.add(new Thread(reservationTask));
                }
                for (Thread thread : threads) {
                    thread.start();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                continue;
            }
            if (tokens[0].equals("cancel") && tokens.length == 4 && ars != null) {
                ars.cancel(tokens[1], tokens[2], tokens[3]);
                continue;
            }
            if (tokens[0].equals("list") && tokens.length == 3 && ars != null) {
                List<String> reservations = ars.list(tokens[1], tokens[2]);
                if (reservations.size() <= 0) continue;
                reader.println((CharSequence)("  Reservation holder : " + reservations.get(0)));
                if (reservations.size() <= 1) continue;
                reader.println((CharSequence)("  Wait list : " + reservations.subList(1, reservations.size())));
                continue;
            }
            if (tokens[0].equals("quit") && tokens.length == 1) break;
            if (tokens[0].equals("connect") && tokens.length == 6 && ars == null) {
                ZooKeeperInstance zki = new ZooKeeperInstance((Configuration)new ClientConfiguration(new Configuration[0]).withInstance(tokens[1]).withZkHosts(tokens[2]));
                Connector conn = zki.getConnector(tokens[3], (AuthenticationToken)new PasswordToken((CharSequence)tokens[4]));
                if (conn.tableOperations().exists(tokens[5])) {
                    ars = new ARS(conn, tokens[5]);
                    reader.println((CharSequence)"  connected");
                    continue;
                }
                reader.println((CharSequence)"  No Such Table");
                continue;
            }
            System.out.println("  Commands : ");
            if (ars == null) {
                reader.println((CharSequence)"    connect <instance> <zookeepers> <user> <pass> <table>");
                continue;
            }
            reader.println((CharSequence)"    reserve <what> <when> <who> {who}");
            reader.println((CharSequence)"    cancel <what> <when> <who>");
            reader.println((CharSequence)"    list <what> <when>");
        }
    }

    public static enum ReservationResult {
        RESERVED,
        WAIT_LISTED;

    }
}

