/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce.bulk;

import com.beust.jcommander.Parameter;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class VerifyIngest {
    private static final Logger log = Logger.getLogger(VerifyIngest.class);

    public static void main(String[] args) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Opts opts = new Opts();
        opts.parseArgs(VerifyIngest.class.getName(), args, new Object[0]);
        Connector connector = opts.getConnector();
        Scanner scanner = connector.createScanner(opts.tableName, opts.auths);
        scanner.setRange(new Range(new Text(String.format("row_%010d", opts.startRow)), null));
        Iterator si = scanner.iterator();
        boolean ok = true;
        for (int i = opts.startRow; i < opts.numRows; ++i) {
            if (si.hasNext()) {
                Map.Entry entry = (Map.Entry)si.next();
                if (!((Key)entry.getKey()).getRow().toString().equals(String.format("row_%010d", i))) {
                    log.error((Object)("unexpected row key " + ((Key)entry.getKey()).getRow().toString() + " expected " + String.format("row_%010d", i)));
                    ok = false;
                }
                if (((Value)entry.getValue()).toString().equals(String.format("value_%010d", i))) continue;
                log.error((Object)("unexpected value " + ((Value)entry.getValue()).toString() + " expected " + String.format("value_%010d", i)));
                ok = false;
                continue;
            }
            log.error((Object)("no more rows, expected " + String.format("row_%010d", i)));
            ok = false;
            break;
        }
        if (ok) {
            System.out.println("OK");
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--start-row"})
        int startRow = 0;
        @Parameter(names={"--count"}, required=true, description="number of rows to verify")
        int numRows = 0;

        Opts() {
        }
    }
}

