/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.examples.simple.mapreduce.JobUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class UniqueColumns
extends Configured
implements Tool {
    private static final Text EMPTY = new Text();

    public int run(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(UniqueColumns.class.getName(), args, new Object[0]);
        String jobName = ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis();
        Job job = JobUtil.getJob(this.getConf());
        job.setJobName(jobName);
        job.setJarByClass(((Object)((Object)this)).getClass());
        String clone = opts.tableName;
        Connector conn = null;
        opts.setAccumuloConfigs(job);
        if (opts.offline) {
            conn = opts.getConnector();
            clone = opts.tableName + "_" + jobName;
            conn.tableOperations().clone(opts.tableName, clone, true, new HashMap(), new HashSet());
            conn.tableOperations().offline(clone);
            AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)true);
            AccumuloInputFormat.setInputTableName((Job)job, (String)clone);
        }
        job.setInputFormatClass(AccumuloInputFormat.class);
        job.setMapperClass(UMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setCombinerClass(UReducer.class);
        job.setReducerClass(UReducer.class);
        job.setNumReduceTasks(opts.reducers);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(opts.output));
        job.waitForCompletion(true);
        if (opts.offline) {
            conn.tableOperations().delete(clone);
        }
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new UniqueColumns(), (String[])args);
        System.exit(res);
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--output"}, description="output directory")
        String output;
        @Parameter(names={"--reducers"}, description="number of reducers to use", required=true)
        int reducers;
        @Parameter(names={"--offline"}, description="run against an offline table")
        boolean offline = false;

        Opts() {
        }
    }

    public static class UReducer
    extends Reducer<Text, Text, Text, Text> {
        public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)EMPTY);
        }
    }

    public static class UMapper
    extends Mapper<Key, Value, Text, Text> {
        private Text temp = new Text();
        private static final Text CF = new Text("cf:");
        private static final Text CQ = new Text("cq:");

        public void map(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
            this.temp.set(CF);
            ByteSequence cf = key.getColumnFamilyData();
            this.temp.append(cf.getBackingArray(), cf.offset(), cf.length());
            context.write((Object)this.temp, (Object)EMPTY);
            this.temp.set(CQ);
            ByteSequence cq = key.getColumnQualifierData();
            this.temp.append(cq.getBackingArray(), cq.offset(), cq.length());
            context.write((Object)this.temp, (Object)EMPTY);
        }
    }
}

