/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import java.io.IOException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.examples.simple.mapreduce.JobUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TokenFileWordCount
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        String instance = args[0];
        String zookeepers = args[1];
        String user = args[2];
        String tokenFile = args[3];
        String input = args[4];
        String tableName = args[5];
        Job job = JobUtil.getJob(this.getConf());
        job.setJobName(TokenFileWordCount.class.getName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(TextInputFormat.class);
        TextInputFormat.setInputPaths((Job)job, (String)input);
        job.setMapperClass(MapClass.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)ClientConfiguration.loadDefault().withInstance(instance).withZkHosts(zookeepers));
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)user, (String)tokenFile);
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)tableName);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TokenFileWordCount(), (String[])args);
        System.exit(res);
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, Mutation> {
        public void map(LongWritable key, Text value, Mapper.Context output) throws IOException {
            String[] words;
            for (String word : words = value.toString().split("\\s+")) {
                Mutation mutation = new Mutation(new Text(word));
                mutation.put(new Text("count"), new Text("20080906"), new Value("1".getBytes()));
                try {
                    output.write(null, (Object)mutation);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

