/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.examples.simple.mapreduce.JobUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TableToFile
extends Configured
implements Tool {
    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException, AccumuloSecurityException {
        Job job = JobUtil.getJob(this.getConf());
        job.setJobName(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        Opts opts = new Opts();
        opts.parseArgs(((Object)((Object)this)).getClass().getName(), args, new Object[0]);
        job.setInputFormatClass(AccumuloInputFormat.class);
        opts.setAccumuloConfigs(job);
        HashSet<Pair> columnsToFetch = new HashSet<Pair>();
        for (String col : opts.columns.split(",")) {
            Text cq;
            int idx = col.indexOf(":");
            Text cf = new Text(idx < 0 ? col : col.substring(0, idx));
            Text text = cq = idx < 0 ? null : new Text(col.substring(idx + 1));
            if (cf.getLength() <= 0) continue;
            columnsToFetch.add(new Pair((Object)cf, (Object)cq));
        }
        if (!columnsToFetch.isEmpty()) {
            AccumuloInputFormat.fetchColumns((Job)job, columnsToFetch);
        }
        job.setMapperClass(TTFMapper.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(opts.output));
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new TableToFile(), (String[])args);
    }

    public static class TTFMapper
    extends Mapper<Key, Value, NullWritable, Text> {
        public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
            final Key r = row;
            final Value v = data;
            Map.Entry<Key, Value> entry = new Map.Entry<Key, Value>(){

                @Override
                public Key getKey() {
                    return r;
                }

                @Override
                public Value getValue() {
                    return v;
                }

                @Override
                public Value setValue(Value value) {
                    return null;
                }
            };
            context.write((Object)NullWritable.get(), (Object)new Text(DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)false)));
            context.setStatus("Outputed Value");
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--output"}, description="output directory", required=true)
        String output;
        @Parameter(names={"--columns"}, description="columns to extract, in cf:cq{,cf:cq,...} form")
        String columns = "";

        Opts() {
        }
    }
}

