/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.examples.simple.mapreduce.JobUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class RegexExample
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(((Object)((Object)this)).getClass().getName(), args, new Object[0]);
        Job job = JobUtil.getJob(this.getConf());
        job.setJobName(((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(AccumuloInputFormat.class);
        opts.setAccumuloConfigs(job);
        IteratorSetting regex = new IteratorSetting(50, "regex", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)regex, (String)opts.rowRegex, (String)opts.columnFamilyRegex, (String)opts.columnQualifierRegex, (String)opts.valueRegex, (boolean)false);
        AccumuloInputFormat.addIterator((Job)job, (IteratorSetting)regex);
        job.setMapperClass(RegexMapper.class);
        job.setMapOutputKeyClass(Key.class);
        job.setMapOutputValueClass(Value.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(opts.destination));
        System.out.println("setRowRegex: " + opts.rowRegex);
        System.out.println("setColumnFamilyRegex: " + opts.columnFamilyRegex);
        System.out.println("setColumnQualifierRegex: " + opts.columnQualifierRegex);
        System.out.println("setValueRegex: " + opts.valueRegex);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new RegexExample(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--rowRegex"})
        String rowRegex;
        @Parameter(names={"--columnFamilyRegex"})
        String columnFamilyRegex;
        @Parameter(names={"--columnQualifierRegex"})
        String columnQualifierRegex;
        @Parameter(names={"--valueRegex"})
        String valueRegex;
        @Parameter(names={"--output"}, required=true)
        String destination;

        Opts() {
        }
    }

    public static class RegexMapper
    extends Mapper<Key, Value, Key, Value> {
        public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)row, (Object)data);
        }
    }
}

