/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.examples.simple.mapreduce.JobUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class NGramIngest
extends Configured
implements Tool {
    private static final Logger log = Logger.getLogger(NGramIngest.class);

    public int run(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(((Object)((Object)this)).getClass().getName(), args, new Object[0]);
        Job job = JobUtil.getJob(this.getConf());
        job.setJobName(((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        opts.setAccumuloConfigs(job);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setMapperClass(NGramMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setSpeculativeExecution(false);
        if (!opts.getConnector().tableOperations().exists(opts.tableName)) {
            log.info((Object)("Creating table " + opts.tableName));
            opts.getConnector().tableOperations().create(opts.tableName);
            TreeSet<Text> splits = new TreeSet<Text>();
            String[] numbers = "1 2 3 4 5 6 7 8 9".split("\\s");
            String[] lower = "a b c d e f g h i j k l m n o p q r s t u v w x y z".split("\\s");
            String[] upper = "A B C D E F G H I J K L M N O P Q R S T U V W X Y Z".split("\\s");
            String[][] arr$ = new String[][]{numbers, lower, upper};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] array;
                for (String s : array = arr$[i$]) {
                    splits.add(new Text(s));
                }
            }
            opts.getConnector().tableOperations().addSplits(opts.tableName, splits);
        }
        TextInputFormat.addInputPath((Job)job, (Path)new Path(opts.inputDirectory));
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new NGramIngest(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    static class NGramMapper
    extends Mapper<LongWritable, Text, Text, Mutation> {
        NGramMapper() {
        }

        protected void map(LongWritable location, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] parts = value.toString().split("\\t");
            if (parts.length >= 4) {
                Mutation m = new Mutation((CharSequence)parts[0]);
                m.put((CharSequence)parts[1], (CharSequence)String.format("%010d", Long.parseLong(parts[2])), new Value(parts[3].trim().getBytes()));
                context.write(null, (Object)m);
            }
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--input"}, required=true)
        String inputDirectory;

        Opts() {
        }
    }
}

