/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.isolation;

import com.beust.jcommander.Parameter;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class InterferenceTest {
    private static final int NUM_ROWS = 500;
    private static final int NUM_COLUMNS = 113;
    private static final Logger log = Logger.getLogger(InterferenceTest.class);

    public static void main(String[] args) throws Exception {
        Connector conn;
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(InterferenceTest.class.getName(), args, new Object[]{bwOpts});
        if (opts.iterations < 1L) {
            opts.iterations = Long.MAX_VALUE;
        }
        if (!(conn = opts.getConnector()).tableOperations().exists(opts.tableName)) {
            conn.tableOperations().create(opts.tableName);
        }
        Thread writer = new Thread(new Writer(conn.createBatchWriter(opts.tableName, bwOpts.getBatchWriterConfig()), opts.iterations));
        writer.start();
        Reader r = opts.isolated ? new Reader((Scanner)new IsolatedScanner(conn.createScanner(opts.tableName, opts.auths))) : new Reader(conn.createScanner(opts.tableName, opts.auths));
        Thread reader = new Thread(r);
        reader.start();
        writer.join();
        r.stopNow();
        reader.join();
        System.out.println("finished");
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--iterations"}, description="number of times to run", required=true)
        long iterations = 0L;
        @Parameter(names={"--isolated"}, description="use isolated scans")
        boolean isolated = false;

        Opts() {
        }
    }

    static class Reader
    implements Runnable {
        private Scanner scanner;
        volatile boolean stop = false;

        Reader(Scanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public void run() {
            while (!this.stop) {
                ByteSequence row = null;
                int count = 0;
                HashSet<String> values = new HashSet<String>();
                for (Map.Entry entry : this.scanner) {
                    if (row == null) {
                        row = ((Key)entry.getKey()).getRowData();
                    }
                    if (!row.equals((Object)((Key)entry.getKey()).getRowData())) {
                        if (count != 113) {
                            System.err.println("ERROR Did not see 113 columns in row " + row);
                        }
                        if (values.size() > 1) {
                            System.err.println("ERROR Columns in row " + row + " had multiple values " + values);
                        }
                        row = ((Key)entry.getKey()).getRowData();
                        count = 0;
                        values.clear();
                    }
                    ++count;
                    values.add(((Value)entry.getValue()).toString());
                }
                if (count > 0 && count != 113) {
                    System.err.println("ERROR Did not see 113 columns in row " + row);
                }
                if (values.size() <= 1) continue;
                System.err.println("ERROR Columns in row " + row + " had multiple values " + values);
            }
        }

        public void stopNow() {
            this.stop = true;
        }
    }

    static class Writer
    implements Runnable {
        private final BatchWriter bw;
        private final long iterations;

        Writer(BatchWriter bw, long iterations) {
            this.bw = bw;
            this.iterations = iterations;
        }

        @Override
        public void run() {
            int row = 0;
            int value = 0;
            for (long i = 0L; i < this.iterations; ++i) {
                Mutation m = new Mutation(new Text(String.format("%03d", row)));
                row = (row + 1) % 500;
                for (int cq = 0; cq < 113; ++cq) {
                    m.put(new Text("000"), new Text(String.format("%04d", cq)), new Value(("" + value).getBytes()));
                }
                ++value;
                try {
                    this.bw.addMutation(m);
                    continue;
                }
                catch (MutationsRejectedException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            try {
                this.bw.close();
            }
            catch (MutationsRejectedException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

