/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.helloworld;

import com.beust.jcommander.Parameter;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class ReadData {
    private static final Logger log = Logger.getLogger(ReadData.class);

    public static void main(String[] args) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(ReadData.class.getName(), args, new Object[]{scanOpts});
        Connector connector = opts.getConnector();
        Scanner scan = connector.createScanner(opts.tableName, opts.auths);
        scan.setBatchSize(scanOpts.scanBatchSize);
        Key start = null;
        if (opts.startKey != null) {
            start = new Key(new Text(opts.startKey));
        }
        Key end = null;
        if (opts.endKey != null) {
            end = new Key(new Text(opts.endKey));
        }
        scan.setRange(new Range(start, end));
        for (Map.Entry e : scan) {
            Text colf = ((Key)e.getKey()).getColumnFamily();
            Text colq = ((Key)e.getKey()).getColumnQualifier();
            log.trace((Object)("row: " + ((Key)e.getKey()).getRow() + ", colf: " + colf + ", colq: " + colq));
            log.trace((Object)(", value: " + ((Value)e.getValue()).toString()));
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--startKey"})
        String startKey;
        @Parameter(names={"--endKey"})
        String endKey;

        Opts() {
        }
    }
}

