/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.examples.simple.filedata.ChunkCombiner;
import org.apache.accumulo.examples.simple.filedata.KeyUtil;
import org.apache.hadoop.io.Text;

public class FileDataIngest {
    public static final Text CHUNK_CF = new Text("~chunk");
    public static final Text REFS_CF = new Text("refs");
    public static final String REFS_ORIG_FILE = "name";
    public static final String REFS_FILE_EXT = "filext";
    public static final ByteSequence CHUNK_CF_BS = new ArrayByteSequence(CHUNK_CF.getBytes(), 0, CHUNK_CF.getLength());
    public static final ByteSequence REFS_CF_BS = new ArrayByteSequence(REFS_CF.getBytes(), 0, REFS_CF.getLength());
    int chunkSize;
    byte[] chunkSizeBytes;
    byte[] buf;
    MessageDigest md5digest;
    ColumnVisibility cv;

    public FileDataIngest(int chunkSize, ColumnVisibility colvis) {
        this.chunkSize = chunkSize;
        this.chunkSizeBytes = FileDataIngest.intToBytes(chunkSize);
        this.buf = new byte[chunkSize];
        try {
            this.md5digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.cv = colvis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertFileData(String filename, BatchWriter bw) throws MutationsRejectedException, IOException {
        Text chunkCQ;
        if (this.chunkSize == 0) {
            return "";
        }
        this.md5digest.reset();
        String uid = this.hexString(this.md5digest.digest(filename.getBytes()));
        this.md5digest.reset();
        FileInputStream fis = null;
        int numRead = 0;
        try {
            fis = new FileInputStream(filename);
            numRead = ((InputStream)fis).read(this.buf);
            while (numRead >= 0) {
                if (numRead > 0) {
                    this.md5digest.update(this.buf, 0, numRead);
                }
                numRead = ((InputStream)fis).read(this.buf);
            }
        }
        finally {
            if (fis != null) {
                ((InputStream)fis).close();
            }
        }
        String hash = this.hexString(this.md5digest.digest());
        Text row = new Text(hash);
        Mutation m = new Mutation(row);
        m.put(REFS_CF, KeyUtil.buildNullSepText(uid, REFS_ORIG_FILE), this.cv, new Value(filename.getBytes()));
        String fext = FileDataIngest.getExt(filename);
        if (fext != null) {
            m.put(REFS_CF, KeyUtil.buildNullSepText(uid, REFS_FILE_EXT), this.cv, new Value(fext.getBytes()));
        }
        bw.addMutation(m);
        int chunkCount = 0;
        try {
            fis = new FileInputStream(filename);
            numRead = ((InputStream)fis).read(this.buf);
            while (numRead >= 0) {
                while (numRead < this.buf.length) {
                    int moreRead = ((InputStream)fis).read(this.buf, numRead, this.buf.length - numRead);
                    if (moreRead > 0) {
                        numRead += moreRead;
                        continue;
                    }
                    if (moreRead >= 0) continue;
                    break;
                }
                m = new Mutation(row);
                chunkCQ = new Text(this.chunkSizeBytes);
                chunkCQ.append(FileDataIngest.intToBytes(chunkCount), 0, 4);
                m.put(CHUNK_CF, chunkCQ, this.cv, new Value(this.buf, 0, numRead));
                bw.addMutation(m);
                if (chunkCount == Integer.MAX_VALUE) {
                    throw new RuntimeException("too many chunks for file " + filename + ", try raising chunk size");
                }
                ++chunkCount;
                numRead = ((InputStream)fis).read(this.buf);
            }
        }
        finally {
            if (fis != null) {
                ((InputStream)fis).close();
            }
        }
        m = new Mutation(row);
        chunkCQ = new Text(this.chunkSizeBytes);
        chunkCQ.append(FileDataIngest.intToBytes(chunkCount), 0, 4);
        m.put(new Text(CHUNK_CF), chunkCQ, this.cv, new Value(new byte[0]));
        bw.addMutation(m);
        return hash;
    }

    public static int bytesToInt(byte[] b, int offset) {
        if (b.length <= offset + 3) {
            throw new NumberFormatException("couldn't pull integer from bytes at offset " + offset);
        }
        int i = ((b[offset] & 0xFF) << 24) + ((b[offset + 1] & 0xFF) << 16) + ((b[offset + 2] & 0xFF) << 8) + ((b[offset + 3] & 0xFF) << 0);
        return i;
    }

    public static byte[] intToBytes(int l) {
        byte[] b = new byte[]{(byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
        return b;
    }

    private static String getExt(String filename) {
        if (filename.indexOf(".") == -1) {
            return null;
        }
        return filename.substring(filename.lastIndexOf(".") + 1);
    }

    public String hexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(FileDataIngest.class.getName(), args, new Object[]{bwOpts});
        Connector conn = opts.getConnector();
        if (!conn.tableOperations().exists(opts.tableName)) {
            conn.tableOperations().create(opts.tableName);
            conn.tableOperations().attachIterator(opts.tableName, new IteratorSetting(1, ChunkCombiner.class));
        }
        BatchWriter bw = conn.createBatchWriter(opts.tableName, bwOpts.getBatchWriterConfig());
        FileDataIngest fdi = new FileDataIngest(opts.chunkSize, opts.visibility);
        for (String filename : opts.files) {
            fdi.insertFileData(filename, bw);
        }
        bw.close();
        opts.stopTracing();
    }

    public static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--vis"}, description="use a given visibility for the new counts", converter=ClientOpts.VisibilityConverter.class)
        ColumnVisibility visibility = new ColumnVisibility();
        @Parameter(names={"--chunk"}, description="size of the chunks used to store partial files")
        int chunkSize = 65536;
        @Parameter(description="<file> { <file> ... }")
        List<String> files = new ArrayList<String>();
    }
}

