/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.SummingArrayCombiner;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.examples.simple.filedata.ChunkInputFormat;
import org.apache.accumulo.examples.simple.mapreduce.JobUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CharacterHistogram
extends Configured
implements Tool {
    public static final String VIS = "vis";

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)new Configuration(), (Tool)new CharacterHistogram(), (String[])args));
    }

    public int run(String[] args) throws Exception {
        Job job = JobUtil.getJob(this.getConf());
        job.setJobName(((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        Opts opts = new Opts();
        opts.parseArgs(CharacterHistogram.class.getName(), args, new Object[0]);
        job.setInputFormatClass(ChunkInputFormat.class);
        opts.setAccumuloConfigs(job);
        job.getConfiguration().set(VIS, opts.visibilities.toString());
        job.setMapperClass(HistMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--vis"})
        String visibilities = "";

        Opts() {
        }
    }

    public static class HistMapper
    extends Mapper<List<Map.Entry<Key, Value>>, InputStream, Text, Mutation> {
        private ColumnVisibility cv;

        public void map(List<Map.Entry<Key, Value>> k, InputStream v, Mapper.Context context) throws IOException, InterruptedException {
            Long[] hist = new Long[256];
            for (int i = 0; i < hist.length; ++i) {
                hist[i] = 0L;
            }
            int b = v.read();
            while (b >= 0) {
                Long[] longArray = hist;
                int n = b;
                Long.valueOf(longArray[n] + 1L);
                b = v.read();
            }
            v.close();
            Mutation m = new Mutation(k.get(0).getKey().getRow());
            m.put((CharSequence)"info", (CharSequence)"hist", this.cv, new Value(SummingArrayCombiner.STRING_ARRAY_ENCODER.encode(Arrays.asList(hist))));
            context.write((Object)new Text(), (Object)m);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cv = new ColumnVisibility(context.getConfiguration().get(CharacterHistogram.VIS, ""));
        }
    }
}

