/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.constraints;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;

public class NumericValueConstraint
implements Constraint {
    private static final short NON_NUMERIC_VALUE = 1;

    private boolean isNumeric(byte[] bytes) {
        for (byte b : bytes) {
            boolean ok;
            boolean bl = ok = b >= 48 && b <= 57;
            if (ok) continue;
            return false;
        }
        return true;
    }

    private List<Short> addViolation(List<Short> violations, short violation) {
        if (violations == null) {
            violations = new ArrayList<Short>();
            violations.add(violation);
        } else if (!violations.contains(violation)) {
            violations.add(violation);
        }
        return violations;
    }

    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        List<Short> violations = null;
        List updates = mutation.getUpdates();
        for (ColumnUpdate columnUpdate : updates) {
            if (this.isNumeric(columnUpdate.getValue())) continue;
            violations = this.addViolation(violations, (short)1);
        }
        return violations;
    }

    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return "Value is not numeric";
            }
        }
        return null;
    }
}

