/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.client;

import com.beust.jcommander.Parameter;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;

public class TracingExample {
    private static final String DEFAULT_TABLE_NAME = "test";

    public void enableTracing(Opts opts) throws Exception {
        DistributedTrace.enable((Instance)opts.getInstance(), (ZooReader)new ZooReader(opts.getInstance().getZooKeepers(), 15000), (String)"myHost", (String)"myApp");
    }

    public void execute(Opts opts) throws TableNotFoundException, InterruptedException, AccumuloException, AccumuloSecurityException, TableExistsException {
        if (opts.createtable) {
            opts.getConnector().tableOperations().create(opts.getTableName());
        }
        if (opts.createEntries) {
            this.createEntries(opts);
        }
        if (opts.readEntries) {
            this.readEntries(opts);
        }
        if (opts.deletetable) {
            opts.getConnector().tableOperations().delete(opts.getTableName());
        }
    }

    private void createEntries(Opts opts) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Trace.on((String)"Client Write");
        System.out.println("TraceID: " + Long.toHexString(Trace.currentTrace().traceId()));
        BatchWriter batchWriter = opts.getConnector().createBatchWriter(opts.getTableName(), new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        batchWriter.addMutation(m);
        Span flushSpan = Trace.start((String)"Client Flush");
        batchWriter.flush();
        flushSpan.stop();
        batchWriter.close();
        Trace.off();
    }

    private void readEntries(Opts opts) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Scanner scanner = opts.getConnector().createScanner(opts.getTableName(), opts.auths);
        Span readSpan = Trace.on((String)"Client Read");
        System.out.println("TraceID: " + Long.toHexString(Trace.currentTrace().traceId()));
        int numberOfEntriesRead = 0;
        for (Map.Entry entry : scanner) {
            System.out.println(((Key)entry.getKey()).toString() + " -> " + ((Value)entry.getValue()).toString());
            ++numberOfEntriesRead;
        }
        readSpan.data("Number of Entries Read", String.valueOf(numberOfEntriesRead));
        Trace.off();
    }

    public static void main(String[] args) throws Exception {
        TracingExample tracingExample = new TracingExample();
        Opts opts = new Opts();
        ScannerOpts scannerOpts = new ScannerOpts();
        opts.parseArgs(TracingExample.class.getName(), args, new Object[]{scannerOpts});
        tracingExample.enableTracing(opts);
        tracingExample.execute(opts);
    }

    static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"-C", "--createtable"}, description="create table before doing anything")
        boolean createtable = false;
        @Parameter(names={"-D", "--deletetable"}, description="delete table when finished")
        boolean deletetable = false;
        @Parameter(names={"-c", "--create"}, description="create entries before any deletes")
        boolean createEntries = false;
        @Parameter(names={"-r", "--read"}, description="read entries after any creates/deletes")
        boolean readEntries = false;

        public Opts() {
            super(TracingExample.DEFAULT_TABLE_NAME);
            this.auths = new Authorizations();
        }
    }
}

