/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.client;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.trace.TraceDump;
import org.apache.hadoop.io.Text;

public class TraceDumpExample {
    public void dump(Opts opts) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        if (opts.traceId.isEmpty()) {
            throw new IllegalArgumentException("--traceid option is required");
        }
        Scanner scanner = opts.getConnector().createScanner(opts.getTableName(), opts.auths);
        scanner.setRange(new Range(new Text(opts.traceId)));
        TraceDump.printTrace((Scanner)scanner, (TraceDump.Printer)new TraceDump.Printer(){

            public void print(String line) {
                System.out.println(line);
            }
        });
    }

    public static void main(String[] args) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        TraceDumpExample traceDumpExample = new TraceDumpExample();
        Opts opts = new Opts();
        ScannerOpts scannerOpts = new ScannerOpts();
        opts.parseArgs(TraceDumpExample.class.getName(), args, new Object[]{scannerOpts});
        traceDumpExample.dump(opts);
    }

    static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"--traceid"}, description="The hex string id of a given trace, for example 16cfbbd7beec4ae3")
        public String traceId = "";

        public Opts() {
            super("trace");
        }
    }
}

