/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.client;

import com.beust.jcommander.Parameter;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.ByteArraySet;
import org.apache.hadoop.io.Text;

public class ReadWriteExample {
    private static final String DEFAULT_AUTHS = "LEVEL1,GROUP1";
    private static final String DEFAULT_TABLE_NAME = "test";
    private Connector conn;

    private ReadWriteExample() {
    }

    private void execute(Opts opts, ScannerOpts scanOpts) throws Exception {
        this.conn = opts.getConnector();
        Authorizations userAuthorizations = this.conn.securityOperations().getUserAuthorizations(opts.principal);
        ByteArraySet auths = new ByteArraySet((Collection)userAuthorizations.getAuthorizations());
        auths.addAll((Collection)opts.auths.getAuthorizations());
        if (!auths.isEmpty()) {
            this.conn.securityOperations().changeUserAuthorizations(opts.principal, new Authorizations((Collection)auths));
        }
        if (opts.createtable) {
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            for (int i = -128; i < 127; ++i) {
                partitionKeys.add(new Text(new byte[]{(byte)i}));
            }
            this.conn.tableOperations().create(opts.getTableName());
            this.conn.tableOperations().addSplits(opts.getTableName(), partitionKeys);
        }
        this.createEntries(opts);
        if (opts.readEntries) {
            Scanner scanner = this.conn.createScanner(opts.getTableName(), opts.auths);
            scanner.setBatchSize(scanOpts.scanBatchSize);
            for (Map.Entry entry : scanner) {
                System.out.println(((Key)entry.getKey()).toString() + " -> " + ((Value)entry.getValue()).toString());
            }
        }
        if (opts.deletetable) {
            this.conn.tableOperations().delete(opts.getTableName());
        }
    }

    private void createEntries(Opts opts) throws Exception {
        if (opts.createEntries || opts.deleteEntries) {
            BatchWriter writer = this.conn.createBatchWriter(opts.getTableName(), new BatchWriterConfig());
            ColumnVisibility cv = new ColumnVisibility(opts.auths.toString().replace(',', '|'));
            Text cf = new Text("datatypes");
            Text cq = new Text("xml");
            byte[] row = new byte[]{104, 101, 108, 108, 111, 0};
            byte[] value = new byte[]{119, 111, 114, 108, 100, 0};
            for (int i = 0; i < 10; ++i) {
                row[row.length - 1] = (byte)i;
                Mutation m = new Mutation(new Text(row));
                if (opts.deleteEntries) {
                    m.putDelete(cf, cq, cv);
                }
                if (opts.createEntries) {
                    value[value.length - 1] = (byte)i;
                    m.put(cf, cq, cv, new Value(value));
                }
                writer.addMutation(m);
            }
            writer.close();
        }
    }

    public static void main(String[] args) throws Exception {
        ReadWriteExample rwe = new ReadWriteExample();
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(ReadWriteExample.class.getName(), args, new Object[]{scanOpts});
        rwe.execute(opts, scanOpts);
    }

    static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"-C", "--createtable"}, description="create table before doing anything")
        boolean createtable = false;
        @Parameter(names={"-D", "--deletetable"}, description="delete table when finished")
        boolean deletetable = false;
        @Parameter(names={"-c", "--create"}, description="create entries before any deletes")
        boolean createEntries = false;
        @Parameter(names={"-r", "--read"}, description="read entries after any creates/deletes")
        boolean readEntries = false;
        @Parameter(names={"-d", "--delete"}, description="delete entries after any creates")
        boolean deleteEntries = false;

        public Opts() {
            super(ReadWriteExample.DEFAULT_TABLE_NAME);
            this.auths = new Authorizations(ReadWriteExample.DEFAULT_AUTHS.split(","));
        }
    }
}

