/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.client;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.examples.simple.client.RandomBatchWriter;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

class CountingVerifyingReceiver {
    private static final Logger log = Logger.getLogger(CountingVerifyingReceiver.class);
    long count = 0L;
    int expectedValueSize = 0;
    HashMap<Text, Boolean> expectedRows;

    CountingVerifyingReceiver(HashMap<Text, Boolean> expectedRows, int expectedValueSize) {
        this.expectedRows = expectedRows;
        this.expectedValueSize = expectedValueSize;
    }

    public void receive(Key key, Value value) {
        String row = key.getRow().toString();
        long rowid = Integer.parseInt(row.split("_")[1]);
        byte[] expectedValue = RandomBatchWriter.createValue(rowid, this.expectedValueSize);
        if (!Arrays.equals(expectedValue, value.get())) {
            log.error((Object)("Got unexpected value for " + key + " expected : " + new String(expectedValue) + " got : " + new String(value.get())));
        }
        if (!this.expectedRows.containsKey(key.getRow())) {
            log.error((Object)("Got unexpected key " + key));
        } else {
            this.expectedRows.put(key.getRow(), true);
        }
        ++this.count;
    }
}

