/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.diagram.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.resource.Get;

public class ProcessInstanceHighlightsResource
extends SecuredResource {
    private RuntimeService runtimeService = ActivitiUtil.getRuntimeService();
    private RepositoryServiceImpl repositoryService = (RepositoryServiceImpl)ActivitiUtil.getRepositoryService();
    private HistoryService historyService = ActivitiUtil.getHistoryService();
    private ProcessInstance processInstance;
    private ProcessDefinitionEntity processDefinition;
    List<String> historicActivityInstanceList = new ArrayList<String>();
    List<String> highLightedFlows = new ArrayList<String>();
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Get(value="json")
    public ObjectNode getHighlighted() {
        String processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiException("No process instance id provided");
        }
        ObjectNode responseJSON = this.objectMapper.createObjectNode();
        responseJSON.put("processInstanceId", processInstanceId);
        ArrayNode activitiesArray = this.objectMapper.createArrayNode();
        ArrayNode flowsArray = this.objectMapper.createArrayNode();
        try {
            this.processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            this.processDefinition = (ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(this.processInstance.getProcessDefinitionId());
            responseJSON.put("processDefinitionId", this.processInstance.getProcessDefinitionId());
            List highLightedActivities = this.runtimeService.getActiveActivityIds(processInstanceId);
            List<String> highLightedFlows = this.getHighLightedFlows(this.processDefinition, processInstanceId);
            for (String activityId : highLightedActivities) {
                activitiesArray.add(activityId);
            }
            for (String flow : highLightedFlows) {
                flowsArray.add(flow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        responseJSON.put("activities", (JsonNode)activitiesArray);
        responseJSON.put("flows", (JsonNode)flowsArray);
        return responseJSON;
    }

    private List<String> getHighLightedFlows(ProcessDefinitionEntity processDefinition, String processInstanceId) {
        ArrayList<String> highLightedFlows = new ArrayList<String>();
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        LinkedList<HistoricActivityInstance> hisActInstList = new LinkedList<HistoricActivityInstance>();
        hisActInstList.addAll(historicActivityInstances);
        this.getHighlightedFlows(processDefinition.getActivities(), hisActInstList, highLightedFlows);
        return highLightedFlows;
    }

    private void getHighlightedFlows(List<ActivityImpl> activityList, LinkedList<HistoricActivityInstance> hisActInstList, List<String> highLightedFlows) {
        PvmTransition startTrans;
        ArrayList<ActivityImpl> startEventActList = new ArrayList<ActivityImpl>();
        HashMap<String, ActivityImpl> activityMap = new HashMap<String, ActivityImpl>(activityList.size());
        for (ActivityImpl activity : activityList) {
            activityMap.put(activity.getId(), activity);
            String actType = (String)activity.getProperty("type");
            if (actType == null || actType.toLowerCase().indexOf("startevent") < 0) continue;
            startEventActList.add(activity);
        }
        HistoricActivityInstance firstHistActInst = hisActInstList.getFirst();
        String firstActType = firstHistActInst.getActivityType();
        if (firstActType != null && firstActType.toLowerCase().indexOf("startevent") < 0 && (startTrans = this.getStartTransaction(startEventActList, firstHistActInst)) != null) {
            highLightedFlows.add(startTrans.getId());
        }
        while (hisActInstList.size() > 0) {
            HistoricActivityInstance histActInst = hisActInstList.removeFirst();
            ActivityImpl activity = (ActivityImpl)activityMap.get(histActInst.getActivityId());
            if (activity == null) continue;
            boolean isParallel = false;
            String type = histActInst.getActivityType();
            if ("parallelGateway".equals(type) || "inclusiveGateway".equals(type)) {
                isParallel = true;
            } else if ("subProcess".equals(histActInst.getActivityType())) {
                this.getHighlightedFlows(activity.getActivities(), hisActInstList, highLightedFlows);
            }
            ArrayList<PvmTransition> allOutgoingTrans = new ArrayList<PvmTransition>();
            allOutgoingTrans.addAll(activity.getOutgoingTransitions());
            allOutgoingTrans.addAll(this.getBoundaryEventOutgoingTransitions(activity));
            List<String> activityHighLightedFlowIds = this.getHighlightedFlows(allOutgoingTrans, hisActInstList, isParallel);
            highLightedFlows.addAll(activityHighLightedFlowIds);
        }
    }

    private PvmTransition getStartTransaction(List<ActivityImpl> startEventActList, HistoricActivityInstance firstActInst) {
        for (ActivityImpl startEventAct : startEventActList) {
            for (PvmTransition trans : startEventAct.getOutgoingTransitions()) {
                if (!trans.getDestination().getId().equals(firstActInst.getActivityId())) continue;
                return trans;
            }
        }
        return null;
    }

    private List<PvmTransition> getBoundaryEventOutgoingTransitions(ActivityImpl activity) {
        ArrayList<PvmTransition> boundaryTrans = new ArrayList<PvmTransition>();
        for (ActivityImpl subActivity : activity.getActivities()) {
            String type = (String)subActivity.getProperty("type");
            if (type == null || type.toLowerCase().indexOf("boundary") < 0) continue;
            boundaryTrans.addAll(subActivity.getOutgoingTransitions());
        }
        return boundaryTrans;
    }

    private List<String> getHighlightedFlows(List<PvmTransition> pvmTransitionList, LinkedList<HistoricActivityInstance> hisActInstList, boolean isParallel) {
        ArrayList<String> highLightedFlowIds = new ArrayList<String>();
        PvmTransition earliestTrans = null;
        HistoricActivityInstance earliestHisActInst = null;
        for (PvmTransition pvmTransition : pvmTransitionList) {
            String destActId = pvmTransition.getDestination().getId();
            HistoricActivityInstance destHisActInst = this.findHisActInst(hisActInstList, destActId);
            if (destHisActInst == null) continue;
            if (isParallel) {
                highLightedFlowIds.add(pvmTransition.getId());
                continue;
            }
            if (earliestHisActInst != null && earliestHisActInst.getId().compareTo(destHisActInst.getId()) <= 0) continue;
            earliestTrans = pvmTransition;
            earliestHisActInst = destHisActInst;
        }
        if (!isParallel && earliestTrans != null) {
            highLightedFlowIds.add(earliestTrans.getId());
        }
        return highLightedFlowIds;
    }

    private HistoricActivityInstance findHisActInst(LinkedList<HistoricActivityInstance> hisActInstList, String actId) {
        for (HistoricActivityInstance hisActInst : hisActInstList) {
            if (!hisActInst.getActivityId().equals(actId)) continue;
            return hisActInst;
        }
        return null;
    }
}

