/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.interceptor;

import com.mingsoft.basic.interceptor.BaseInterceptor;
import com.mingsoft.people.constant.e.CookieConstEnum;
import com.mingsoft.people.constant.e.SessionConstEnum;
import com.mingsoft.util.StringUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;

public class ActionInterceptor
extends BaseInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.getSession(request, SessionConstEnum.PEOPLE_SESSION) == null) {
            String loginUrl = this.getCookie(request, CookieConstEnum.PEOPLE_LOGIN_URL);
            if (StringUtil.isBlank((String)loginUrl)) {
                response.sendRedirect(BasicUtil.getUrl() + "/error/404.do");
                return false;
            }
            String login = URLDecoder.decode(loginUrl, "utf-8");
            String backUrl = BasicUtil.getUrl() + request.getServletPath();
            if (request.getQueryString() != null) {
                backUrl = backUrl + "?" + request.getQueryString();
            }
            login = login.indexOf("?") > 0 ? login + "&url=" + URLEncoder.encode(backUrl, "utf-8") : login + "?url=" + URLEncoder.encode(backUrl, "utf-8");
            response.sendRedirect(login);
            return false;
        }
        return true;
    }
}

