/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mybatis3;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Module;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.core.provider.SingleProvider;
import net.hasor.db.mybatis3.InnerSqlMapperProxy;
import net.hasor.db.mybatis3.SqlExecutorOperations;
import net.hasor.db.mybatis3.SqlExecutorTemplate;
import net.hasor.db.mybatis3.SqlExecutorTemplateProvider;
import net.hasor.utils.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisModule
implements Module {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String dataSourceID = null;
    private Supplier<SqlSessionFactory> sessionFactory = null;

    public MyBatisModule(String sqlmapConfig) throws IOException {
        this(null, (Supplier<SqlSessionFactory>)MyBatisModule.defaultSessionFactory(sqlmapConfig));
    }

    public MyBatisModule(SqlSessionFactory sessionFactory) {
        this(null, InstanceProvider.of((Object)Objects.requireNonNull(sessionFactory, "sessionFactory is null.")));
    }

    public MyBatisModule(Supplier<SqlSessionFactory> sessionFactory) {
        this(null, sessionFactory);
    }

    public MyBatisModule(String dataSourceID, String sqlmapConfig) throws IOException {
        this(dataSourceID, (Supplier<SqlSessionFactory>)MyBatisModule.defaultSessionFactory(sqlmapConfig));
    }

    public MyBatisModule(String dataSourceID, SqlSessionFactory sessionFactory) {
        this(dataSourceID, InstanceProvider.of((Object)Objects.requireNonNull(sessionFactory, "sessionFactory is null.")));
    }

    public MyBatisModule(String dataSourceID, Supplier<SqlSessionFactory> sessionFactory) {
        this.dataSourceID = dataSourceID;
        this.sessionFactory = Objects.requireNonNull(sessionFactory, "sessionFactory is null.");
    }

    private static SingleProvider<SqlSessionFactory> defaultSessionFactory(String sqlmapConfig) throws IOException {
        Objects.requireNonNull(sqlmapConfig, "sqlmapConfig is null.");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Reader resourceAsReader = Resources.getResourceAsReader((ClassLoader)loader, (String)sqlmapConfig);
        Reader reader = Objects.requireNonNull(resourceAsReader, "could not find resource '" + sqlmapConfig + "'");
        return new SingleProvider(() -> new SqlSessionFactoryBuilder().build(reader));
    }

    public void loadModule(ApiBinder apiBinder) {
        Supplier dataSource;
        BindInfo bindInfo;
        if (StringUtils.isBlank((String)this.dataSourceID)) {
            bindInfo = apiBinder.getBindInfo(DataSource.class);
            if (bindInfo == null) {
                throw new IllegalStateException("need DataSource.");
            }
            dataSource = apiBinder.getProvider(bindInfo);
            SqlExecutorTemplateProvider templateProvider = new SqlExecutorTemplateProvider(this.sessionFactory, dataSource);
            apiBinder.bindType(SqlExecutorTemplate.class).toProvider((Supplier)templateProvider);
            apiBinder.bindType(SqlExecutorOperations.class).toProvider((Supplier)templateProvider);
        } else {
            bindInfo = apiBinder.findBindingRegister(this.dataSourceID, DataSource.class);
            if (bindInfo == null) {
                throw new IllegalStateException("need DataSource.");
            }
            dataSource = apiBinder.getProvider(bindInfo);
            SqlExecutorTemplateProvider templateProvider = new SqlExecutorTemplateProvider(this.sessionFactory, dataSource);
            apiBinder.bindType(SqlExecutorTemplate.class).nameWith(this.dataSourceID).toProvider((Supplier)templateProvider);
            apiBinder.bindType(SqlExecutorOperations.class).nameWith(this.dataSourceID).toProvider((Supplier)templateProvider);
        }
        Supplier contextSupplier = apiBinder.getProvider(AppContext.class);
        Collection mappers = this.sessionFactory.get().getConfiguration().getMapperRegistry().getMappers();
        mappers.forEach(arg_0 -> this.lambda$loadModule$1(apiBinder, (Supplier)contextSupplier, arg_0));
        this.logger.info("mysql mybatis init ok.");
    }

    private /* synthetic */ void lambda$loadModule$1(ApiBinder apiBinder, Supplier contextSupplier, Class mapper) {
        apiBinder.bindType(mapper).toProvider(new InnerSqlMapperProxy(mapper, contextSupplier));
        this.logger.info("Registering Ibatis Mapper: {}", (Object)mapper.getClass().getName());
    }
}

